package zio.aws.opensearchserverless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.opensearchserverless.model.primitives.{
  SamlUserAttribute,
  SamlConfigOptionsSessionTimeoutInteger,
  SamlMetadata,
  SamlGroupAttribute
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SamlConfigOptions(
    groupAttribute: Optional[SamlGroupAttribute] = Optional.Absent,
    metadata: SamlMetadata,
    sessionTimeout: Optional[SamlConfigOptionsSessionTimeoutInteger] =
      Optional.Absent,
    userAttribute: Optional[SamlUserAttribute] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.SamlConfigOptions = {
    import SamlConfigOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.SamlConfigOptions
      .builder()
      .optionallyWith(
        groupAttribute.map(value =>
          SamlGroupAttribute.unwrap(value): java.lang.String
        )
      )(_.groupAttribute)
      .metadata(SamlMetadata.unwrap(metadata): java.lang.String)
      .optionallyWith(
        sessionTimeout.map(value =>
          SamlConfigOptionsSessionTimeoutInteger.unwrap(value): Integer
        )
      )(_.sessionTimeout)
      .optionallyWith(
        userAttribute.map(value =>
          SamlUserAttribute.unwrap(value): java.lang.String
        )
      )(_.userAttribute)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.SamlConfigOptions.ReadOnly =
    zio.aws.opensearchserverless.model.SamlConfigOptions.wrap(buildAwsValue())
}
object SamlConfigOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.SamlConfigOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.SamlConfigOptions =
      zio.aws.opensearchserverless.model.SamlConfigOptions(
        groupAttribute.map(value => value),
        metadata,
        sessionTimeout.map(value => value),
        userAttribute.map(value => value)
      )
    def groupAttribute: Optional[SamlGroupAttribute]
    def metadata: SamlMetadata
    def sessionTimeout: Optional[SamlConfigOptionsSessionTimeoutInteger]
    def userAttribute: Optional[SamlUserAttribute]
    def getGroupAttribute: ZIO[Any, AwsError, SamlGroupAttribute] =
      AwsError.unwrapOptionField("groupAttribute", groupAttribute)
    def getMetadata: ZIO[Any, Nothing, SamlMetadata] = ZIO.succeed(metadata)
    def getSessionTimeout
        : ZIO[Any, AwsError, SamlConfigOptionsSessionTimeoutInteger] =
      AwsError.unwrapOptionField("sessionTimeout", sessionTimeout)
    def getUserAttribute: ZIO[Any, AwsError, SamlUserAttribute] =
      AwsError.unwrapOptionField("userAttribute", userAttribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.SamlConfigOptions
  ) extends zio.aws.opensearchserverless.model.SamlConfigOptions.ReadOnly {
    override val groupAttribute: Optional[SamlGroupAttribute] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupAttribute())
        .map(value =>
          zio.aws.opensearchserverless.model.primitives
            .SamlGroupAttribute(value)
        )
    override val metadata: SamlMetadata =
      zio.aws.opensearchserverless.model.primitives
        .SamlMetadata(impl.metadata())
    override val sessionTimeout
        : Optional[SamlConfigOptionsSessionTimeoutInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionTimeout())
        .map(value =>
          zio.aws.opensearchserverless.model.primitives
            .SamlConfigOptionsSessionTimeoutInteger(value)
        )
    override val userAttribute: Optional[SamlUserAttribute] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userAttribute())
        .map(value =>
          zio.aws.opensearchserverless.model.primitives.SamlUserAttribute(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.SamlConfigOptions
  ): zio.aws.opensearchserverless.model.SamlConfigOptions.ReadOnly =
    new Wrapper(impl)
}
