package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetLifecyclePolicyResponse(
    lifecyclePolicyDetails: Optional[
      Iterable[zio.aws.opensearchserverless.model.LifecyclePolicyDetail]
    ] = Optional.Absent,
    lifecyclePolicyErrorDetails: Optional[
      Iterable[zio.aws.opensearchserverless.model.LifecyclePolicyErrorDetail]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.BatchGetLifecyclePolicyResponse = {
    import BatchGetLifecyclePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.BatchGetLifecyclePolicyResponse
      .builder()
      .optionallyWith(
        lifecyclePolicyDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lifecyclePolicyDetails)
      .optionallyWith(
        lifecyclePolicyErrorDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lifecyclePolicyErrorDetails)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.BatchGetLifecyclePolicyResponse.ReadOnly =
    zio.aws.opensearchserverless.model.BatchGetLifecyclePolicyResponse
      .wrap(buildAwsValue())
}
object BatchGetLifecyclePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.BatchGetLifecyclePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.BatchGetLifecyclePolicyResponse =
      zio.aws.opensearchserverless.model.BatchGetLifecyclePolicyResponse(
        lifecyclePolicyDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lifecyclePolicyErrorDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def lifecyclePolicyDetails: Optional[
      List[zio.aws.opensearchserverless.model.LifecyclePolicyDetail.ReadOnly]
    ]
    def lifecyclePolicyErrorDetails: Optional[List[
      zio.aws.opensearchserverless.model.LifecyclePolicyErrorDetail.ReadOnly
    ]]
    def getLifecyclePolicyDetails: ZIO[Any, AwsError, List[
      zio.aws.opensearchserverless.model.LifecyclePolicyDetail.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "lifecyclePolicyDetails",
      lifecyclePolicyDetails
    )
    def getLifecyclePolicyErrorDetails: ZIO[Any, AwsError, List[
      zio.aws.opensearchserverless.model.LifecyclePolicyErrorDetail.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "lifecyclePolicyErrorDetails",
      lifecyclePolicyErrorDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.BatchGetLifecyclePolicyResponse
  ) extends zio.aws.opensearchserverless.model.BatchGetLifecyclePolicyResponse.ReadOnly {
    override val lifecyclePolicyDetails: Optional[
      List[zio.aws.opensearchserverless.model.LifecyclePolicyDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lifecyclePolicyDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearchserverless.model.LifecyclePolicyDetail.wrap(item)
        }.toList
      )
    override val lifecyclePolicyErrorDetails: Optional[List[
      zio.aws.opensearchserverless.model.LifecyclePolicyErrorDetail.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.lifecyclePolicyErrorDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearchserverless.model.LifecyclePolicyErrorDetail
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.BatchGetLifecyclePolicyResponse
  ): zio.aws.opensearchserverless.model.BatchGetLifecyclePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
