package zio.aws.opensearchserverless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.opensearchserverless.model.primitives.ListCollectionsRequestMaxResultsInteger
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListCollectionsRequest(
    collectionFilters: Optional[
      zio.aws.opensearchserverless.model.CollectionFilters
    ] = Optional.Absent,
    maxResults: Optional[ListCollectionsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsRequest = {
    import ListCollectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsRequest
      .builder()
      .optionallyWith(collectionFilters.map(value => value.buildAwsValue()))(
        _.collectionFilters
      )
      .optionallyWith(
        maxResults.map(value =>
          ListCollectionsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.ListCollectionsRequest.ReadOnly =
    zio.aws.opensearchserverless.model.ListCollectionsRequest
      .wrap(buildAwsValue())
}
object ListCollectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.ListCollectionsRequest =
      zio.aws.opensearchserverless.model.ListCollectionsRequest(
        collectionFilters.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def collectionFilters: Optional[
      zio.aws.opensearchserverless.model.CollectionFilters.ReadOnly
    ]
    def maxResults: Optional[ListCollectionsRequestMaxResultsInteger]
    def nextToken: Optional[String]
    def getCollectionFilters: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.CollectionFilters.ReadOnly
    ] = AwsError.unwrapOptionField("collectionFilters", collectionFilters)
    def getMaxResults
        : ZIO[Any, AwsError, ListCollectionsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsRequest
  ) extends zio.aws.opensearchserverless.model.ListCollectionsRequest.ReadOnly {
    override val collectionFilters: Optional[
      zio.aws.opensearchserverless.model.CollectionFilters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.collectionFilters())
      .map(value =>
        zio.aws.opensearchserverless.model.CollectionFilters.wrap(value)
      )
    override val maxResults: Optional[ListCollectionsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.opensearchserverless.model.primitives
            .ListCollectionsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsRequest
  ): zio.aws.opensearchserverless.model.ListCollectionsRequest.ReadOnly =
    new Wrapper(impl)
}
