package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{
  ConfigName,
  ConfigDescription,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSecurityConfigRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    description: Optional[ConfigDescription] = Optional.Absent,
    name: ConfigName,
    samlOptions: Optional[
      zio.aws.opensearchserverless.model.SamlConfigOptions
    ] = Optional.Absent,
    `type`: zio.aws.opensearchserverless.model.SecurityConfigType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityConfigRequest = {
    import CreateSecurityConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityConfigRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value =>
          ConfigDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .name(ConfigName.unwrap(name): java.lang.String)
      .optionallyWith(samlOptions.map(value => value.buildAwsValue()))(
        _.samlOptions
      )
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.CreateSecurityConfigRequest.ReadOnly =
    zio.aws.opensearchserverless.model.CreateSecurityConfigRequest
      .wrap(buildAwsValue())
}
object CreateSecurityConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.CreateSecurityConfigRequest =
      zio.aws.opensearchserverless.model.CreateSecurityConfigRequest(
        clientToken.map(value => value),
        description.map(value => value),
        name,
        samlOptions.map(value => value.asEditable),
        `type`
      )
    def clientToken: Optional[ClientToken]
    def description: Optional[ConfigDescription]
    def name: ConfigName
    def samlOptions: Optional[
      zio.aws.opensearchserverless.model.SamlConfigOptions.ReadOnly
    ]
    def `type`: zio.aws.opensearchserverless.model.SecurityConfigType
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, ConfigDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, ConfigName] = ZIO.succeed(name)
    def getSamlOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.SamlConfigOptions.ReadOnly
    ] = AwsError.unwrapOptionField("samlOptions", samlOptions)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.opensearchserverless.model.SecurityConfigType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityConfigRequest
  ) extends zio.aws.opensearchserverless.model.CreateSecurityConfigRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.ClientToken(value)
      )
    override val description: Optional[ConfigDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.opensearchserverless.model.primitives.ConfigDescription(value)
        )
    override val name: ConfigName =
      zio.aws.opensearchserverless.model.primitives.ConfigName(impl.name())
    override val samlOptions: Optional[
      zio.aws.opensearchserverless.model.SamlConfigOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.samlOptions())
      .map(value =>
        zio.aws.opensearchserverless.model.SamlConfigOptions.wrap(value)
      )
    override val `type`: zio.aws.opensearchserverless.model.SecurityConfigType =
      zio.aws.opensearchserverless.model.SecurityConfigType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityConfigRequest
  ): zio.aws.opensearchserverless.model.CreateSecurityConfigRequest.ReadOnly =
    new Wrapper(impl)
}
