package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{
  SubnetId,
  SecurityGroupId,
  VpcEndpointName,
  VpcEndpointId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateVpcEndpointDetail(
    id: Optional[VpcEndpointId] = Optional.Absent,
    lastModifiedDate: Optional[Long] = Optional.Absent,
    name: Optional[VpcEndpointName] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    status: Optional[zio.aws.opensearchserverless.model.VpcEndpointStatus] =
      Optional.Absent,
    subnetIds: Optional[Iterable[SubnetId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.UpdateVpcEndpointDetail = {
    import UpdateVpcEndpointDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.UpdateVpcEndpointDetail
      .builder()
      .optionallyWith(
        id.map(value => VpcEndpointId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(lastModifiedDate.map(value => value: java.lang.Long))(
        _.lastModifiedDate
      )
      .optionallyWith(
        name.map(value => VpcEndpointName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.UpdateVpcEndpointDetail.ReadOnly =
    zio.aws.opensearchserverless.model.UpdateVpcEndpointDetail
      .wrap(buildAwsValue())
}
object UpdateVpcEndpointDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.UpdateVpcEndpointDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.UpdateVpcEndpointDetail =
      zio.aws.opensearchserverless.model.UpdateVpcEndpointDetail(
        id.map(value => value),
        lastModifiedDate.map(value => value),
        name.map(value => value),
        securityGroupIds.map(value => value),
        status.map(value => value),
        subnetIds.map(value => value)
      )
    def id: Optional[VpcEndpointId]
    def lastModifiedDate: Optional[Long]
    def name: Optional[VpcEndpointName]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def status: Optional[zio.aws.opensearchserverless.model.VpcEndpointStatus]
    def subnetIds: Optional[List[SubnetId]]
    def getId: ZIO[Any, AwsError, VpcEndpointId] =
      AwsError.unwrapOptionField("id", id)
    def getLastModifiedDate: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getName: ZIO[Any, AwsError, VpcEndpointName] =
      AwsError.unwrapOptionField("name", name)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.VpcEndpointStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateVpcEndpointDetail
  ) extends zio.aws.opensearchserverless.model.UpdateVpcEndpointDetail.ReadOnly {
    override val id: Optional[VpcEndpointId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.VpcEndpointId(value)
      )
    override val lastModifiedDate: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => value: Long)
    override val name: Optional[VpcEndpointName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.VpcEndpointName(value)
      )
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearchserverless.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val status
        : Optional[zio.aws.opensearchserverless.model.VpcEndpointStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.opensearchserverless.model.VpcEndpointStatus.wrap(value)
        )
    override val subnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearchserverless.model.primitives.SubnetId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateVpcEndpointDetail
  ): zio.aws.opensearchserverless.model.UpdateVpcEndpointDetail.ReadOnly =
    new Wrapper(impl)
}
