package zio.aws.opensearchserverless.model
import scala.jdk.CollectionConverters.*
sealed trait CollectionStatus {
  def unwrap: software.amazon.awssdk.services.opensearchserverless.model.CollectionStatus
}
object CollectionStatus {
  def wrap(
      value: software.amazon.awssdk.services.opensearchserverless.model.CollectionStatus
  ): zio.aws.opensearchserverless.model.CollectionStatus = value match {
    case software.amazon.awssdk.services.opensearchserverless.model.CollectionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearchserverless.model.CollectionStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.opensearchserverless.model.CollectionStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.opensearchserverless.model.CollectionStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.opensearchserverless.model.CollectionStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearchserverless.model.CollectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearchserverless.model.CollectionStatus =
      software.amazon.awssdk.services.opensearchserverless.model.CollectionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING
      extends zio.aws.opensearchserverless.model.CollectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearchserverless.model.CollectionStatus =
      software.amazon.awssdk.services.opensearchserverless.model.CollectionStatus.CREATING
  }
  case object DELETING
      extends zio.aws.opensearchserverless.model.CollectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearchserverless.model.CollectionStatus =
      software.amazon.awssdk.services.opensearchserverless.model.CollectionStatus.DELETING
  }
  case object ACTIVE
      extends zio.aws.opensearchserverless.model.CollectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearchserverless.model.CollectionStatus =
      software.amazon.awssdk.services.opensearchserverless.model.CollectionStatus.ACTIVE
  }
  case object FAILED
      extends zio.aws.opensearchserverless.model.CollectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.opensearchserverless.model.CollectionStatus =
      software.amazon.awssdk.services.opensearchserverless.model.CollectionStatus.FAILED
  }
}
