package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{
  SecurityConfigId,
  ConfigDescription,
  PolicyVersion
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SecurityConfigSummary(
    configVersion: Optional[PolicyVersion] = Optional.Absent,
    createdDate: Optional[Long] = Optional.Absent,
    description: Optional[ConfigDescription] = Optional.Absent,
    id: Optional[SecurityConfigId] = Optional.Absent,
    lastModifiedDate: Optional[Long] = Optional.Absent,
    `type`: Optional[zio.aws.opensearchserverless.model.SecurityConfigType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigSummary = {
    import SecurityConfigSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigSummary
      .builder()
      .optionallyWith(
        configVersion.map(value =>
          PolicyVersion.unwrap(value): java.lang.String
        )
      )(_.configVersion)
      .optionallyWith(createdDate.map(value => value: java.lang.Long))(
        _.createdDate
      )
      .optionallyWith(
        description.map(value =>
          ConfigDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        id.map(value => SecurityConfigId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(lastModifiedDate.map(value => value: java.lang.Long))(
        _.lastModifiedDate
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.SecurityConfigSummary.ReadOnly =
    zio.aws.opensearchserverless.model.SecurityConfigSummary
      .wrap(buildAwsValue())
}
object SecurityConfigSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.SecurityConfigSummary =
      zio.aws.opensearchserverless.model.SecurityConfigSummary(
        configVersion.map(value => value),
        createdDate.map(value => value),
        description.map(value => value),
        id.map(value => value),
        lastModifiedDate.map(value => value),
        `type`.map(value => value)
      )
    def configVersion: Optional[PolicyVersion]
    def createdDate: Optional[Long]
    def description: Optional[ConfigDescription]
    def id: Optional[SecurityConfigId]
    def lastModifiedDate: Optional[Long]
    def `type`: Optional[zio.aws.opensearchserverless.model.SecurityConfigType]
    def getConfigVersion: ZIO[Any, AwsError, PolicyVersion] =
      AwsError.unwrapOptionField("configVersion", configVersion)
    def getCreatedDate: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getDescription: ZIO[Any, AwsError, ConfigDescription] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, AwsError, SecurityConfigId] =
      AwsError.unwrapOptionField("id", id)
    def getLastModifiedDate: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.SecurityConfigType
    ] = AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigSummary
  ) extends zio.aws.opensearchserverless.model.SecurityConfigSummary.ReadOnly {
    override val configVersion: Optional[PolicyVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.configVersion())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.PolicyVersion(value)
      )
    override val createdDate: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => value: Long)
    override val description: Optional[ConfigDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.opensearchserverless.model.primitives.ConfigDescription(value)
        )
    override val id: Optional[SecurityConfigId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.SecurityConfigId(value)
      )
    override val lastModifiedDate: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => value: Long)
    override val `type`
        : Optional[zio.aws.opensearchserverless.model.SecurityConfigType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.opensearchserverless.model.SecurityConfigType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigSummary
  ): zio.aws.opensearchserverless.model.SecurityConfigSummary.ReadOnly =
    new Wrapper(impl)
}
