package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.PolicyName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetAccessPolicyRequest(
    name: PolicyName,
    `type`: zio.aws.opensearchserverless.model.AccessPolicyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.GetAccessPolicyRequest = {
    import GetAccessPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.GetAccessPolicyRequest
      .builder()
      .name(PolicyName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.GetAccessPolicyRequest.ReadOnly =
    zio.aws.opensearchserverless.model.GetAccessPolicyRequest
      .wrap(buildAwsValue())
}
object GetAccessPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.GetAccessPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.GetAccessPolicyRequest =
      zio.aws.opensearchserverless.model.GetAccessPolicyRequest(name, `type`)
    def name: PolicyName
    def `type`: zio.aws.opensearchserverless.model.AccessPolicyType
    def getName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(name)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.opensearchserverless.model.AccessPolicyType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.GetAccessPolicyRequest
  ) extends zio.aws.opensearchserverless.model.GetAccessPolicyRequest.ReadOnly {
    override val name: PolicyName =
      zio.aws.opensearchserverless.model.primitives.PolicyName(impl.name())
    override val `type`: zio.aws.opensearchserverless.model.AccessPolicyType =
      zio.aws.opensearchserverless.model.AccessPolicyType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.GetAccessPolicyRequest
  ): zio.aws.opensearchserverless.model.GetAccessPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
