package zio.aws.opensearchserverless.model
import scala.jdk.CollectionConverters.*
sealed trait AccessPolicyType {
  def unwrap: software.amazon.awssdk.services.opensearchserverless.model.AccessPolicyType
}
object AccessPolicyType {
  def wrap(
      value: software.amazon.awssdk.services.opensearchserverless.model.AccessPolicyType
  ): zio.aws.opensearchserverless.model.AccessPolicyType = value match {
    case software.amazon.awssdk.services.opensearchserverless.model.AccessPolicyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearchserverless.model.AccessPolicyType.DATA =>
      val r = data
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearchserverless.model.AccessPolicyType {
    override def unwrap
        : software.amazon.awssdk.services.opensearchserverless.model.AccessPolicyType =
      software.amazon.awssdk.services.opensearchserverless.model.AccessPolicyType.UNKNOWN_TO_SDK_VERSION
  }
  case object data extends zio.aws.opensearchserverless.model.AccessPolicyType {
    override def unwrap
        : software.amazon.awssdk.services.opensearchserverless.model.AccessPolicyType =
      software.amazon.awssdk.services.opensearchserverless.model.AccessPolicyType.DATA
  }
}
