package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{
  PolicyVersion,
  PolicyName,
  PolicyDescription,
  PolicyDocument,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateAccessPolicyRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    description: Optional[PolicyDescription] = Optional.Absent,
    name: PolicyName,
    policy: Optional[PolicyDocument] = Optional.Absent,
    policyVersion: PolicyVersion,
    `type`: zio.aws.opensearchserverless.model.AccessPolicyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.UpdateAccessPolicyRequest = {
    import UpdateAccessPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.UpdateAccessPolicyRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value =>
          PolicyDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .name(PolicyName.unwrap(name): java.lang.String)
      .optionallyWith(
        policy.map(value => PolicyDocument.unwrap(value): java.lang.String)
      )(_.policy)
      .policyVersion(PolicyVersion.unwrap(policyVersion): java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.UpdateAccessPolicyRequest.ReadOnly =
    zio.aws.opensearchserverless.model.UpdateAccessPolicyRequest
      .wrap(buildAwsValue())
}
object UpdateAccessPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.UpdateAccessPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.UpdateAccessPolicyRequest =
      zio.aws.opensearchserverless.model.UpdateAccessPolicyRequest(
        clientToken.map(value => value),
        description.map(value => value),
        name,
        policy.map(value => value),
        policyVersion,
        `type`
      )
    def clientToken: Optional[ClientToken]
    def description: Optional[PolicyDescription]
    def name: PolicyName
    def policy: Optional[PolicyDocument]
    def policyVersion: PolicyVersion
    def `type`: zio.aws.opensearchserverless.model.AccessPolicyType
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, PolicyDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(name)
    def getPolicy: ZIO[Any, AwsError, PolicyDocument] =
      AwsError.unwrapOptionField("policy", policy)
    def getPolicyVersion: ZIO[Any, Nothing, PolicyVersion] =
      ZIO.succeed(policyVersion)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.opensearchserverless.model.AccessPolicyType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateAccessPolicyRequest
  ) extends zio.aws.opensearchserverless.model.UpdateAccessPolicyRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.ClientToken(value)
      )
    override val description: Optional[PolicyDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.opensearchserverless.model.primitives.PolicyDescription(value)
        )
    override val name: PolicyName =
      zio.aws.opensearchserverless.model.primitives.PolicyName(impl.name())
    override val policy: Optional[PolicyDocument] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.PolicyDocument(value)
      )
    override val policyVersion: PolicyVersion =
      zio.aws.opensearchserverless.model.primitives
        .PolicyVersion(impl.policyVersion())
    override val `type`: zio.aws.opensearchserverless.model.AccessPolicyType =
      zio.aws.opensearchserverless.model.AccessPolicyType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateAccessPolicyRequest
  ): zio.aws.opensearchserverless.model.UpdateAccessPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
