package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{
  SubnetId,
  VpcId,
  SecurityGroupId,
  ClientToken,
  VpcEndpointName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateVpcEndpointRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    name: VpcEndpointName,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    subnetIds: Iterable[SubnetId],
    vpcId: VpcId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.CreateVpcEndpointRequest = {
    import CreateVpcEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.CreateVpcEndpointRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .name(VpcEndpointName.unwrap(name): java.lang.String)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .subnetIds(subnetIds.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.CreateVpcEndpointRequest.ReadOnly =
    zio.aws.opensearchserverless.model.CreateVpcEndpointRequest
      .wrap(buildAwsValue())
}
object CreateVpcEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.CreateVpcEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.CreateVpcEndpointRequest =
      zio.aws.opensearchserverless.model.CreateVpcEndpointRequest(
        clientToken.map(value => value),
        name,
        securityGroupIds.map(value => value),
        subnetIds,
        vpcId
      )
    def clientToken: Optional[ClientToken]
    def name: VpcEndpointName
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def subnetIds: List[SubnetId]
    def vpcId: VpcId
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getName: ZIO[Any, Nothing, VpcEndpointName] = ZIO.succeed(name)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetIds: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnetIds)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CreateVpcEndpointRequest
  ) extends zio.aws.opensearchserverless.model.CreateVpcEndpointRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.ClientToken(value)
      )
    override val name: VpcEndpointName =
      zio.aws.opensearchserverless.model.primitives.VpcEndpointName(impl.name())
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearchserverless.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val subnetIds: List[SubnetId] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.opensearchserverless.model.primitives.SubnetId(item)
      }
      .toList
    override val vpcId: VpcId =
      zio.aws.opensearchserverless.model.primitives.VpcId(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CreateVpcEndpointRequest
  ): zio.aws.opensearchserverless.model.CreateVpcEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
