package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{
  CollectionName,
  CollectionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CollectionDetail(
    arn: Optional[String] = Optional.Absent,
    collectionEndpoint: Optional[String] = Optional.Absent,
    createdDate: Optional[Long] = Optional.Absent,
    dashboardEndpoint: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    id: Optional[CollectionId] = Optional.Absent,
    kmsKeyArn: Optional[String] = Optional.Absent,
    lastModifiedDate: Optional[Long] = Optional.Absent,
    name: Optional[CollectionName] = Optional.Absent,
    status: Optional[zio.aws.opensearchserverless.model.CollectionStatus] =
      Optional.Absent,
    `type`: Optional[zio.aws.opensearchserverless.model.CollectionType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.CollectionDetail = {
    import CollectionDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.CollectionDetail
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(collectionEndpoint.map(value => value: java.lang.String))(
        _.collectionEndpoint
      )
      .optionallyWith(createdDate.map(value => value: java.lang.Long))(
        _.createdDate
      )
      .optionallyWith(dashboardEndpoint.map(value => value: java.lang.String))(
        _.dashboardEndpoint
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        id.map(value => CollectionId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(kmsKeyArn.map(value => value: java.lang.String))(
        _.kmsKeyArn
      )
      .optionallyWith(lastModifiedDate.map(value => value: java.lang.Long))(
        _.lastModifiedDate
      )
      .optionallyWith(
        name.map(value => CollectionName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.opensearchserverless.model.CollectionDetail.ReadOnly =
    zio.aws.opensearchserverless.model.CollectionDetail.wrap(buildAwsValue())
}
object CollectionDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.CollectionDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.CollectionDetail =
      zio.aws.opensearchserverless.model.CollectionDetail(
        arn.map(value => value),
        collectionEndpoint.map(value => value),
        createdDate.map(value => value),
        dashboardEndpoint.map(value => value),
        description.map(value => value),
        id.map(value => value),
        kmsKeyArn.map(value => value),
        lastModifiedDate.map(value => value),
        name.map(value => value),
        status.map(value => value),
        `type`.map(value => value)
      )
    def arn: Optional[String]
    def collectionEndpoint: Optional[String]
    def createdDate: Optional[Long]
    def dashboardEndpoint: Optional[String]
    def description: Optional[String]
    def id: Optional[CollectionId]
    def kmsKeyArn: Optional[String]
    def lastModifiedDate: Optional[Long]
    def name: Optional[CollectionName]
    def status: Optional[zio.aws.opensearchserverless.model.CollectionStatus]
    def `type`: Optional[zio.aws.opensearchserverless.model.CollectionType]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getCollectionEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("collectionEndpoint", collectionEndpoint)
    def getCreatedDate: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getDashboardEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dashboardEndpoint", dashboardEndpoint)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, AwsError, CollectionId] =
      AwsError.unwrapOptionField("id", id)
    def getKmsKeyArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getLastModifiedDate: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getName: ZIO[Any, AwsError, CollectionName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.CollectionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.CollectionType
    ] = AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CollectionDetail
  ) extends zio.aws.opensearchserverless.model.CollectionDetail.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val collectionEndpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.collectionEndpoint())
      .map(value => value: String)
    override val createdDate: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => value: Long)
    override val dashboardEndpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dashboardEndpoint())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val id: Optional[CollectionId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.CollectionId(value)
      )
    override val kmsKeyArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => value: String)
    override val lastModifiedDate: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => value: Long)
    override val name: Optional[CollectionName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.CollectionName(value)
      )
    override val status
        : Optional[zio.aws.opensearchserverless.model.CollectionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.opensearchserverless.model.CollectionStatus.wrap(value)
        )
    override val `type`
        : Optional[zio.aws.opensearchserverless.model.CollectionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.opensearchserverless.model.CollectionType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CollectionDetail
  ): zio.aws.opensearchserverless.model.CollectionDetail.ReadOnly = new Wrapper(
    impl
  )
}
