package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetCollectionResponse(
    collectionDetails: Optional[
      Iterable[zio.aws.opensearchserverless.model.CollectionDetail]
    ] = Optional.Absent,
    collectionErrorDetails: Optional[
      Iterable[zio.aws.opensearchserverless.model.CollectionErrorDetail]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.BatchGetCollectionResponse = {
    import BatchGetCollectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.BatchGetCollectionResponse
      .builder()
      .optionallyWith(
        collectionDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.collectionDetails)
      .optionallyWith(
        collectionErrorDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.collectionErrorDetails)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.BatchGetCollectionResponse.ReadOnly =
    zio.aws.opensearchserverless.model.BatchGetCollectionResponse
      .wrap(buildAwsValue())
}
object BatchGetCollectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.BatchGetCollectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.BatchGetCollectionResponse =
      zio.aws.opensearchserverless.model.BatchGetCollectionResponse(
        collectionDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        collectionErrorDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def collectionDetails: Optional[
      List[zio.aws.opensearchserverless.model.CollectionDetail.ReadOnly]
    ]
    def collectionErrorDetails: Optional[
      List[zio.aws.opensearchserverless.model.CollectionErrorDetail.ReadOnly]
    ]
    def getCollectionDetails: ZIO[Any, AwsError, List[
      zio.aws.opensearchserverless.model.CollectionDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("collectionDetails", collectionDetails)
    def getCollectionErrorDetails: ZIO[Any, AwsError, List[
      zio.aws.opensearchserverless.model.CollectionErrorDetail.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "collectionErrorDetails",
      collectionErrorDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.BatchGetCollectionResponse
  ) extends zio.aws.opensearchserverless.model.BatchGetCollectionResponse.ReadOnly {
    override val collectionDetails: Optional[
      List[zio.aws.opensearchserverless.model.CollectionDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.collectionDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearchserverless.model.CollectionDetail.wrap(item)
        }.toList
      )
    override val collectionErrorDetails: Optional[
      List[zio.aws.opensearchserverless.model.CollectionErrorDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.collectionErrorDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearchserverless.model.CollectionErrorDetail.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.BatchGetCollectionResponse
  ): zio.aws.opensearchserverless.model.BatchGetCollectionResponse.ReadOnly =
    new Wrapper(impl)
}
