package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AccessPolicyStats(
    dataPolicyCount: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.AccessPolicyStats = {
    import AccessPolicyStats.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.AccessPolicyStats
      .builder()
      .optionallyWith(dataPolicyCount.map(value => value: java.lang.Long))(
        _.dataPolicyCount
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.AccessPolicyStats.ReadOnly =
    zio.aws.opensearchserverless.model.AccessPolicyStats.wrap(buildAwsValue())
}
object AccessPolicyStats {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.AccessPolicyStats
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.AccessPolicyStats =
      zio.aws.opensearchserverless.model
        .AccessPolicyStats(dataPolicyCount.map(value => value))
    def dataPolicyCount: Optional[Long]
    def getDataPolicyCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("dataPolicyCount", dataPolicyCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.AccessPolicyStats
  ) extends zio.aws.opensearchserverless.model.AccessPolicyStats.ReadOnly {
    override val dataPolicyCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.dataPolicyCount())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.AccessPolicyStats
  ): zio.aws.opensearchserverless.model.AccessPolicyStats.ReadOnly =
    new Wrapper(impl)
}
