package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{
  SecurityConfigId,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteSecurityConfigRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    id: SecurityConfigId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.DeleteSecurityConfigRequest = {
    import DeleteSecurityConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.DeleteSecurityConfigRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .id(SecurityConfigId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.DeleteSecurityConfigRequest.ReadOnly =
    zio.aws.opensearchserverless.model.DeleteSecurityConfigRequest
      .wrap(buildAwsValue())
}
object DeleteSecurityConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.DeleteSecurityConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.DeleteSecurityConfigRequest =
      zio.aws.opensearchserverless.model
        .DeleteSecurityConfigRequest(clientToken.map(value => value), id)
    def clientToken: Optional[ClientToken]
    def id: SecurityConfigId
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getId: ZIO[Any, Nothing, SecurityConfigId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.DeleteSecurityConfigRequest
  ) extends zio.aws.opensearchserverless.model.DeleteSecurityConfigRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.ClientToken(value)
      )
    override val id: SecurityConfigId =
      zio.aws.opensearchserverless.model.primitives.SecurityConfigId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.DeleteSecurityConfigRequest
  ): zio.aws.opensearchserverless.model.DeleteSecurityConfigRequest.ReadOnly =
    new Wrapper(impl)
}
