package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSecurityConfigsResponse(
    nextToken: Optional[String] = Optional.Absent,
    securityConfigSummaries: Optional[
      Iterable[zio.aws.opensearchserverless.model.SecurityConfigSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsResponse = {
    import ListSecurityConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        securityConfigSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityConfigSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.ListSecurityConfigsResponse.ReadOnly =
    zio.aws.opensearchserverless.model.ListSecurityConfigsResponse
      .wrap(buildAwsValue())
}
object ListSecurityConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.ListSecurityConfigsResponse =
      zio.aws.opensearchserverless.model.ListSecurityConfigsResponse(
        nextToken.map(value => value),
        securityConfigSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def securityConfigSummaries: Optional[
      List[zio.aws.opensearchserverless.model.SecurityConfigSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSecurityConfigSummaries: ZIO[Any, AwsError, List[
      zio.aws.opensearchserverless.model.SecurityConfigSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "securityConfigSummaries",
      securityConfigSummaries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsResponse
  ) extends zio.aws.opensearchserverless.model.ListSecurityConfigsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val securityConfigSummaries: Optional[
      List[zio.aws.opensearchserverless.model.SecurityConfigSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.securityConfigSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearchserverless.model.SecurityConfigSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsResponse
  ): zio.aws.opensearchserverless.model.ListSecurityConfigsResponse.ReadOnly =
    new Wrapper(impl)
}
