package zio.aws.opensearchserverless
import zio.aws.opensearchserverless.model.UpdateSecurityPolicyResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.opensearchserverless.{
  OpenSearchServerlessAsyncClientBuilder,
  OpenSearchServerlessAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.opensearchserverless.model.{
  BatchGetVpcEndpointRequest,
  UpdateSecurityPolicyRequest,
  BatchGetCollectionRequest,
  CreateCollectionRequest,
  GetPoliciesStatsRequest,
  DeleteCollectionRequest,
  UpdateAccountSettingsRequest,
  CreateAccessPolicyRequest,
  UpdateVpcEndpointRequest,
  ListSecurityPoliciesRequest,
  DeleteSecurityPolicyRequest,
  DeleteAccessPolicyRequest,
  UpdateSecurityConfigRequest,
  UpdateCollectionRequest,
  DeleteSecurityConfigRequest,
  ListTagsForResourceRequest,
  ListVpcEndpointsRequest,
  ListSecurityConfigsRequest,
  GetSecurityConfigRequest,
  DeleteVpcEndpointRequest,
  ListCollectionsRequest,
  GetAccessPolicyRequest,
  GetSecurityPolicyRequest,
  CreateVpcEndpointRequest,
  UntagResourceRequest,
  CreateSecurityConfigRequest,
  UpdateAccessPolicyRequest,
  GetAccountSettingsRequest,
  CreateSecurityPolicyRequest,
  TagResourceRequest,
  ListAccessPoliciesRequest
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.opensearchserverless.model.{
  ListSecurityPoliciesResponse,
  CreateCollectionResponse,
  GetAccessPolicyResponse,
  ListVpcEndpointsResponse,
  ListCollectionsResponse,
  CreateVpcEndpointResponse,
  CreateAccessPolicyResponse,
  ListSecurityConfigsResponse,
  CreateSecurityConfigResponse,
  BatchGetVpcEndpointResponse,
  CreateSecurityPolicyResponse,
  UpdateAccessPolicyResponse,
  DeleteVpcEndpointResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  GetPoliciesStatsResponse,
  UpdateVpcEndpointResponse,
  DeleteCollectionResponse,
  DeleteAccessPolicyResponse,
  GetSecurityConfigResponse,
  UpdateAccountSettingsResponse,
  GetAccountSettingsResponse,
  DeleteSecurityPolicyResponse,
  UpdateSecurityConfigResponse,
  BatchGetCollectionResponse,
  ListAccessPoliciesResponse,
  UpdateSecurityPolicyResponse,
  TagResourceResponse,
  GetSecurityPolicyResponse,
  UpdateCollectionResponse,
  DeleteSecurityConfigResponse
}
import scala.jdk.CollectionConverters.*
trait OpenSearchServerless extends AspectSupport[OpenSearchServerless] {
  val api: OpenSearchServerlessAsyncClient
  def updateAccessPolicy(request: UpdateAccessPolicyRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.UpdateAccessPolicyResponse.ReadOnly
  ]
  def listSecurityPolicies(request: ListSecurityPoliciesRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.ListSecurityPoliciesResponse.ReadOnly
  ]
  def createCollection(request: CreateCollectionRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.CreateCollectionResponse.ReadOnly
  ]
  def createAccessPolicy(request: CreateAccessPolicyRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.CreateAccessPolicyResponse.ReadOnly
  ]
  def batchGetVpcEndpoint(request: BatchGetVpcEndpointRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.BatchGetVpcEndpointResponse.ReadOnly
  ]
  def updateSecurityConfig(request: UpdateSecurityConfigRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.UpdateSecurityConfigResponse.ReadOnly
  ]
  def getPoliciesStats(request: GetPoliciesStatsRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.GetPoliciesStatsResponse.ReadOnly
  ]
  def createSecurityConfig(request: CreateSecurityConfigRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.CreateSecurityConfigResponse.ReadOnly
  ]
  def createSecurityPolicy(request: CreateSecurityPolicyRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.CreateSecurityPolicyResponse.ReadOnly
  ]
  def deleteCollection(request: DeleteCollectionRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.DeleteCollectionResponse.ReadOnly
  ]
  def deleteAccessPolicy(request: DeleteAccessPolicyRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.DeleteAccessPolicyResponse.ReadOnly
  ]
  def getSecurityConfig(request: GetSecurityConfigRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.GetSecurityConfigResponse.ReadOnly
  ]
  def getAccessPolicy(request: GetAccessPolicyRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.GetAccessPolicyResponse.ReadOnly
  ]
  def listAccessPolicies(request: ListAccessPoliciesRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.ListAccessPoliciesResponse.ReadOnly
  ]
  def untagResource(request: UntagResourceRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.UntagResourceResponse.ReadOnly
  ]
  def deleteSecurityPolicy(request: DeleteSecurityPolicyRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.DeleteSecurityPolicyResponse.ReadOnly
  ]
  def listVpcEndpoints(request: ListVpcEndpointsRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.ListVpcEndpointsResponse.ReadOnly
  ]
  def deleteVpcEndpoint(request: DeleteVpcEndpointRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.DeleteVpcEndpointResponse.ReadOnly
  ]
  def createVpcEndpoint(request: CreateVpcEndpointRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.CreateVpcEndpointResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(request: TagResourceRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.TagResourceResponse.ReadOnly
  ]
  def updateAccountSettings(request: UpdateAccountSettingsRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.UpdateAccountSettingsResponse.ReadOnly
  ]
  def deleteSecurityConfig(request: DeleteSecurityConfigRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.DeleteSecurityConfigResponse.ReadOnly
  ]
  def listCollections(request: ListCollectionsRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.ListCollectionsResponse.ReadOnly
  ]
  def updateCollection(request: UpdateCollectionRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.UpdateCollectionResponse.ReadOnly
  ]
  def getAccountSettings(request: GetAccountSettingsRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.GetAccountSettingsResponse.ReadOnly
  ]
  def listSecurityConfigs(request: ListSecurityConfigsRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.ListSecurityConfigsResponse.ReadOnly
  ]
  def getSecurityPolicy(request: GetSecurityPolicyRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.GetSecurityPolicyResponse.ReadOnly
  ]
  def updateVpcEndpoint(request: UpdateVpcEndpointRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.UpdateVpcEndpointResponse.ReadOnly
  ]
  def updateSecurityPolicy(
      request: UpdateSecurityPolicyRequest
  ): IO[AwsError, ReadOnly]
  def batchGetCollection(request: BatchGetCollectionRequest): IO[
    AwsError,
    zio.aws.opensearchserverless.model.BatchGetCollectionResponse.ReadOnly
  ]
}
object OpenSearchServerless {
  val live: ZLayer[AwsConfig, java.lang.Throwable, OpenSearchServerless] =
    customized(identity)
  def customized(
      customization: OpenSearchServerlessAsyncClientBuilder => OpenSearchServerlessAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, OpenSearchServerless] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: OpenSearchServerlessAsyncClientBuilder => OpenSearchServerlessAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, OpenSearchServerless] =
    for (
      awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
      builder = OpenSearchServerlessAsyncClient
        .builder()
        .asyncConfiguration(
          software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
            .builder()
            .advancedOption(
              software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
              executor.asJava
            )
            .build()
        );
      b0 <- awsConfig.configure[
        OpenSearchServerlessAsyncClient,
        OpenSearchServerlessAsyncClientBuilder
      ](builder);
      b1 <- awsConfig.configureHttpClient[
        OpenSearchServerlessAsyncClient,
        OpenSearchServerlessAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
    )
      yield new OpenSearchServerlessImpl(
        client,
        AwsCallAspect.identity,
        ZEnvironment.empty
      )
  private class OpenSearchServerlessImpl[R](
      override val api: OpenSearchServerlessAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends OpenSearchServerless
      with AwsServiceBase[R] {
    override val serviceName: String = "OpenSearchServerless"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): OpenSearchServerlessImpl[R1] =
      new OpenSearchServerlessImpl(api, newAspect, r)
    def updateAccessPolicy(request: UpdateAccessPolicyRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.UpdateAccessPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.UpdateAccessPolicyRequest,
      UpdateAccessPolicyResponse
    ]("updateAccessPolicy", api.updateAccessPolicy)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.UpdateAccessPolicyResponse.wrap)
      .provideEnvironment(r)
    def listSecurityPolicies(request: ListSecurityPoliciesRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.ListSecurityPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesRequest,
      ListSecurityPoliciesResponse
    ]("listSecurityPolicies", api.listSecurityPolicies)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.ListSecurityPoliciesResponse.wrap)
      .provideEnvironment(r)
    def createCollection(request: CreateCollectionRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.CreateCollectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.CreateCollectionRequest,
      CreateCollectionResponse
    ]("createCollection", api.createCollection)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.CreateCollectionResponse.wrap)
      .provideEnvironment(r)
    def createAccessPolicy(request: CreateAccessPolicyRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.CreateAccessPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.CreateAccessPolicyRequest,
      CreateAccessPolicyResponse
    ]("createAccessPolicy", api.createAccessPolicy)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.CreateAccessPolicyResponse.wrap)
      .provideEnvironment(r)
    def batchGetVpcEndpoint(request: BatchGetVpcEndpointRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.BatchGetVpcEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.BatchGetVpcEndpointRequest,
      BatchGetVpcEndpointResponse
    ]("batchGetVpcEndpoint", api.batchGetVpcEndpoint)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.BatchGetVpcEndpointResponse.wrap)
      .provideEnvironment(r)
    def updateSecurityConfig(request: UpdateSecurityConfigRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.UpdateSecurityConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityConfigRequest,
      UpdateSecurityConfigResponse
    ]("updateSecurityConfig", api.updateSecurityConfig)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.UpdateSecurityConfigResponse.wrap)
      .provideEnvironment(r)
    def getPoliciesStats(request: GetPoliciesStatsRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.GetPoliciesStatsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.GetPoliciesStatsRequest,
      GetPoliciesStatsResponse
    ]("getPoliciesStats", api.getPoliciesStats)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.GetPoliciesStatsResponse.wrap)
      .provideEnvironment(r)
    def createSecurityConfig(request: CreateSecurityConfigRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.CreateSecurityConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityConfigRequest,
      CreateSecurityConfigResponse
    ]("createSecurityConfig", api.createSecurityConfig)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.CreateSecurityConfigResponse.wrap)
      .provideEnvironment(r)
    def createSecurityPolicy(request: CreateSecurityPolicyRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.CreateSecurityPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityPolicyRequest,
      CreateSecurityPolicyResponse
    ]("createSecurityPolicy", api.createSecurityPolicy)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.CreateSecurityPolicyResponse.wrap)
      .provideEnvironment(r)
    def deleteCollection(request: DeleteCollectionRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.DeleteCollectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.DeleteCollectionRequest,
      DeleteCollectionResponse
    ]("deleteCollection", api.deleteCollection)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.DeleteCollectionResponse.wrap)
      .provideEnvironment(r)
    def deleteAccessPolicy(request: DeleteAccessPolicyRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.DeleteAccessPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.DeleteAccessPolicyRequest,
      DeleteAccessPolicyResponse
    ]("deleteAccessPolicy", api.deleteAccessPolicy)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.DeleteAccessPolicyResponse.wrap)
      .provideEnvironment(r)
    def getSecurityConfig(request: GetSecurityConfigRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.GetSecurityConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.GetSecurityConfigRequest,
      GetSecurityConfigResponse
    ]("getSecurityConfig", api.getSecurityConfig)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.GetSecurityConfigResponse.wrap)
      .provideEnvironment(r)
    def getAccessPolicy(request: GetAccessPolicyRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.GetAccessPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.GetAccessPolicyRequest,
      GetAccessPolicyResponse
    ]("getAccessPolicy", api.getAccessPolicy)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.GetAccessPolicyResponse.wrap)
      .provideEnvironment(r)
    def listAccessPolicies(request: ListAccessPoliciesRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.ListAccessPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesRequest,
      ListAccessPoliciesResponse
    ]("listAccessPolicies", api.listAccessPolicies)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.ListAccessPoliciesResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteSecurityPolicy(request: DeleteSecurityPolicyRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.DeleteSecurityPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.DeleteSecurityPolicyRequest,
      DeleteSecurityPolicyResponse
    ]("deleteSecurityPolicy", api.deleteSecurityPolicy)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.DeleteSecurityPolicyResponse.wrap)
      .provideEnvironment(r)
    def listVpcEndpoints(request: ListVpcEndpointsRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.ListVpcEndpointsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsRequest,
      ListVpcEndpointsResponse
    ]("listVpcEndpoints", api.listVpcEndpoints)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.ListVpcEndpointsResponse.wrap)
      .provideEnvironment(r)
    def deleteVpcEndpoint(request: DeleteVpcEndpointRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.DeleteVpcEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.DeleteVpcEndpointRequest,
      DeleteVpcEndpointResponse
    ]("deleteVpcEndpoint", api.deleteVpcEndpoint)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.DeleteVpcEndpointResponse.wrap)
      .provideEnvironment(r)
    def createVpcEndpoint(request: CreateVpcEndpointRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.CreateVpcEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.CreateVpcEndpointRequest,
      CreateVpcEndpointResponse
    ]("createVpcEndpoint", api.createVpcEndpoint)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.CreateVpcEndpointResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def updateAccountSettings(request: UpdateAccountSettingsRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.UpdateAccountSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.UpdateAccountSettingsRequest,
      UpdateAccountSettingsResponse
    ]("updateAccountSettings", api.updateAccountSettings)(
      request.buildAwsValue()
    ).map(zio.aws.opensearchserverless.model.UpdateAccountSettingsResponse.wrap)
      .provideEnvironment(r)
    def deleteSecurityConfig(request: DeleteSecurityConfigRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.DeleteSecurityConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.DeleteSecurityConfigRequest,
      DeleteSecurityConfigResponse
    ]("deleteSecurityConfig", api.deleteSecurityConfig)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.DeleteSecurityConfigResponse.wrap)
      .provideEnvironment(r)
    def listCollections(request: ListCollectionsRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.ListCollectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsRequest,
      ListCollectionsResponse
    ]("listCollections", api.listCollections)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.ListCollectionsResponse.wrap)
      .provideEnvironment(r)
    def updateCollection(request: UpdateCollectionRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.UpdateCollectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.UpdateCollectionRequest,
      UpdateCollectionResponse
    ]("updateCollection", api.updateCollection)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.UpdateCollectionResponse.wrap)
      .provideEnvironment(r)
    def getAccountSettings(request: GetAccountSettingsRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.GetAccountSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.GetAccountSettingsRequest,
      GetAccountSettingsResponse
    ]("getAccountSettings", api.getAccountSettings)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.GetAccountSettingsResponse.wrap)
      .provideEnvironment(r)
    def listSecurityConfigs(request: ListSecurityConfigsRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.ListSecurityConfigsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsRequest,
      ListSecurityConfigsResponse
    ]("listSecurityConfigs", api.listSecurityConfigs)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.ListSecurityConfigsResponse.wrap)
      .provideEnvironment(r)
    def getSecurityPolicy(request: GetSecurityPolicyRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.GetSecurityPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.GetSecurityPolicyRequest,
      GetSecurityPolicyResponse
    ]("getSecurityPolicy", api.getSecurityPolicy)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.GetSecurityPolicyResponse.wrap)
      .provideEnvironment(r)
    def updateVpcEndpoint(request: UpdateVpcEndpointRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.UpdateVpcEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.UpdateVpcEndpointRequest,
      UpdateVpcEndpointResponse
    ]("updateVpcEndpoint", api.updateVpcEndpoint)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.UpdateVpcEndpointResponse.wrap)
      .provideEnvironment(r)
    def updateSecurityPolicy(
        request: UpdateSecurityPolicyRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityPolicyRequest,
      UpdateSecurityPolicyResponse
    ]("updateSecurityPolicy", api.updateSecurityPolicy)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.UpdateSecurityPolicyResponse.wrap)
      .provideEnvironment(r)
    def batchGetCollection(request: BatchGetCollectionRequest): IO[
      AwsError,
      zio.aws.opensearchserverless.model.BatchGetCollectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.opensearchserverless.model.BatchGetCollectionRequest,
      BatchGetCollectionResponse
    ]("batchGetCollection", api.batchGetCollection)(request.buildAwsValue())
      .map(zio.aws.opensearchserverless.model.BatchGetCollectionResponse.wrap)
      .provideEnvironment(r)
  }
  def updateAccessPolicy(request: UpdateAccessPolicyRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.UpdateAccessPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAccessPolicy(request))
  def listSecurityPolicies(request: ListSecurityPoliciesRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.ListSecurityPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSecurityPolicies(request))
  def createCollection(request: CreateCollectionRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.CreateCollectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCollection(request))
  def createAccessPolicy(request: CreateAccessPolicyRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.CreateAccessPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAccessPolicy(request))
  def batchGetVpcEndpoint(request: BatchGetVpcEndpointRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.BatchGetVpcEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetVpcEndpoint(request))
  def updateSecurityConfig(request: UpdateSecurityConfigRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.UpdateSecurityConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSecurityConfig(request))
  def getPoliciesStats(request: GetPoliciesStatsRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.GetPoliciesStatsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPoliciesStats(request))
  def createSecurityConfig(request: CreateSecurityConfigRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.CreateSecurityConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSecurityConfig(request))
  def createSecurityPolicy(request: CreateSecurityPolicyRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.CreateSecurityPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSecurityPolicy(request))
  def deleteCollection(request: DeleteCollectionRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.DeleteCollectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCollection(request))
  def deleteAccessPolicy(request: DeleteAccessPolicyRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.DeleteAccessPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAccessPolicy(request))
  def getSecurityConfig(request: GetSecurityConfigRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.GetSecurityConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSecurityConfig(request))
  def getAccessPolicy(request: GetAccessPolicyRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.GetAccessPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccessPolicy(request))
  def listAccessPolicies(request: ListAccessPoliciesRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.ListAccessPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAccessPolicies(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def deleteSecurityPolicy(request: DeleteSecurityPolicyRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.DeleteSecurityPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSecurityPolicy(request))
  def listVpcEndpoints(request: ListVpcEndpointsRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.ListVpcEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVpcEndpoints(request))
  def deleteVpcEndpoint(request: DeleteVpcEndpointRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.DeleteVpcEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVpcEndpoint(request))
  def createVpcEndpoint(request: CreateVpcEndpointRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.CreateVpcEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVpcEndpoint(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def updateAccountSettings(request: UpdateAccountSettingsRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.UpdateAccountSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAccountSettings(request))
  def deleteSecurityConfig(request: DeleteSecurityConfigRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.DeleteSecurityConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSecurityConfig(request))
  def listCollections(request: ListCollectionsRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.ListCollectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCollections(request))
  def updateCollection(request: UpdateCollectionRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.UpdateCollectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCollection(request))
  def getAccountSettings(request: GetAccountSettingsRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.GetAccountSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccountSettings(request))
  def listSecurityConfigs(request: ListSecurityConfigsRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.ListSecurityConfigsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSecurityConfigs(request))
  def getSecurityPolicy(request: GetSecurityPolicyRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.GetSecurityPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSecurityPolicy(request))
  def updateVpcEndpoint(request: UpdateVpcEndpointRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.UpdateVpcEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVpcEndpoint(request))
  def updateSecurityPolicy(request: UpdateSecurityPolicyRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSecurityPolicy(request))
  def batchGetCollection(request: BatchGetCollectionRequest): ZIO[
    zio.aws.opensearchserverless.OpenSearchServerless,
    AwsError,
    zio.aws.opensearchserverless.model.BatchGetCollectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetCollection(request))
}
