package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{PolicyName, ClientToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteAccessPolicyRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    name: PolicyName,
    `type`: zio.aws.opensearchserverless.model.AccessPolicyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.DeleteAccessPolicyRequest = {
    import DeleteAccessPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.DeleteAccessPolicyRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .name(PolicyName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.DeleteAccessPolicyRequest.ReadOnly =
    zio.aws.opensearchserverless.model.DeleteAccessPolicyRequest
      .wrap(buildAwsValue())
}
object DeleteAccessPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.DeleteAccessPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.DeleteAccessPolicyRequest =
      zio.aws.opensearchserverless.model.DeleteAccessPolicyRequest(
        clientToken.map(value => value),
        name,
        `type`
      )
    def clientToken: Optional[ClientToken]
    def name: PolicyName
    def `type`: zio.aws.opensearchserverless.model.AccessPolicyType
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(name)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.opensearchserverless.model.AccessPolicyType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.DeleteAccessPolicyRequest
  ) extends zio.aws.opensearchserverless.model.DeleteAccessPolicyRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.ClientToken(value)
      )
    override val name: PolicyName =
      zio.aws.opensearchserverless.model.primitives.PolicyName(impl.name())
    override val `type`: zio.aws.opensearchserverless.model.AccessPolicyType =
      zio.aws.opensearchserverless.model.AccessPolicyType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.DeleteAccessPolicyRequest
  ): zio.aws.opensearchserverless.model.DeleteAccessPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
