package zio.aws.opensearchserverless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.opensearchserverless.model.primitives.{
  SearchCapacityValue,
  IndexingCapacityValue
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CapacityLimits(
    maxIndexingCapacityInOCU: Optional[IndexingCapacityValue] = Optional.Absent,
    maxSearchCapacityInOCU: Optional[SearchCapacityValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.CapacityLimits = {
    import CapacityLimits.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.CapacityLimits
      .builder()
      .optionallyWith(
        maxIndexingCapacityInOCU.map(value =>
          IndexingCapacityValue.unwrap(value): Integer
        )
      )(_.maxIndexingCapacityInOCU)
      .optionallyWith(
        maxSearchCapacityInOCU.map(value =>
          SearchCapacityValue.unwrap(value): Integer
        )
      )(_.maxSearchCapacityInOCU)
      .build()
  }
  def asReadOnly: zio.aws.opensearchserverless.model.CapacityLimits.ReadOnly =
    zio.aws.opensearchserverless.model.CapacityLimits.wrap(buildAwsValue())
}
object CapacityLimits {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.CapacityLimits
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.CapacityLimits =
      zio.aws.opensearchserverless.model.CapacityLimits(
        maxIndexingCapacityInOCU.map(value => value),
        maxSearchCapacityInOCU.map(value => value)
      )
    def maxIndexingCapacityInOCU: Optional[IndexingCapacityValue]
    def maxSearchCapacityInOCU: Optional[SearchCapacityValue]
    def getMaxIndexingCapacityInOCU: ZIO[Any, AwsError, IndexingCapacityValue] =
      AwsError.unwrapOptionField(
        "maxIndexingCapacityInOCU",
        maxIndexingCapacityInOCU
      )
    def getMaxSearchCapacityInOCU: ZIO[Any, AwsError, SearchCapacityValue] =
      AwsError.unwrapOptionField(
        "maxSearchCapacityInOCU",
        maxSearchCapacityInOCU
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CapacityLimits
  ) extends zio.aws.opensearchserverless.model.CapacityLimits.ReadOnly {
    override val maxIndexingCapacityInOCU: Optional[IndexingCapacityValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxIndexingCapacityInOCU())
        .map(value =>
          zio.aws.opensearchserverless.model.primitives
            .IndexingCapacityValue(value)
        )
    override val maxSearchCapacityInOCU: Optional[SearchCapacityValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxSearchCapacityInOCU())
        .map(value =>
          zio.aws.opensearchserverless.model.primitives
            .SearchCapacityValue(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CapacityLimits
  ): zio.aws.opensearchserverless.model.CapacityLimits.ReadOnly = new Wrapper(
    impl
  )
}
