package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{
  VpcEndpointId,
  ClientToken,
  SubnetId,
  SecurityGroupId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateVpcEndpointRequest(
    addSecurityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    addSubnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    id: VpcEndpointId,
    removeSecurityGroupIds: Optional[Iterable[SecurityGroupId]] =
      Optional.Absent,
    removeSubnetIds: Optional[Iterable[SubnetId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.UpdateVpcEndpointRequest = {
    import UpdateVpcEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.UpdateVpcEndpointRequest
      .builder()
      .optionallyWith(
        addSecurityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.addSecurityGroupIds)
      .optionallyWith(
        addSubnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.addSubnetIds)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .id(VpcEndpointId.unwrap(id): java.lang.String)
      .optionallyWith(
        removeSecurityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.removeSecurityGroupIds)
      .optionallyWith(
        removeSubnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.removeSubnetIds)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.UpdateVpcEndpointRequest.ReadOnly =
    zio.aws.opensearchserverless.model.UpdateVpcEndpointRequest
      .wrap(buildAwsValue())
}
object UpdateVpcEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.UpdateVpcEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.UpdateVpcEndpointRequest =
      zio.aws.opensearchserverless.model.UpdateVpcEndpointRequest(
        addSecurityGroupIds.map(value => value),
        addSubnetIds.map(value => value),
        clientToken.map(value => value),
        id,
        removeSecurityGroupIds.map(value => value),
        removeSubnetIds.map(value => value)
      )
    def addSecurityGroupIds: Optional[List[SecurityGroupId]]
    def addSubnetIds: Optional[List[SubnetId]]
    def clientToken: Optional[ClientToken]
    def id: VpcEndpointId
    def removeSecurityGroupIds: Optional[List[SecurityGroupId]]
    def removeSubnetIds: Optional[List[SubnetId]]
    def getAddSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("addSecurityGroupIds", addSecurityGroupIds)
    def getAddSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("addSubnetIds", addSubnetIds)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getId: ZIO[Any, Nothing, VpcEndpointId] = ZIO.succeed(id)
    def getRemoveSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField(
        "removeSecurityGroupIds",
        removeSecurityGroupIds
      )
    def getRemoveSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("removeSubnetIds", removeSubnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateVpcEndpointRequest
  ) extends zio.aws.opensearchserverless.model.UpdateVpcEndpointRequest.ReadOnly {
    override val addSecurityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearchserverless.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val addSubnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.addSubnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearchserverless.model.primitives.SubnetId(item)
        }.toList
      )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.ClientToken(value)
      )
    override val id: VpcEndpointId =
      zio.aws.opensearchserverless.model.primitives.VpcEndpointId(impl.id())
    override val removeSecurityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearchserverless.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val removeSubnetIds: Optional[List[SubnetId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeSubnetIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearchserverless.model.primitives.SubnetId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateVpcEndpointRequest
  ): zio.aws.opensearchserverless.model.UpdateVpcEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
