package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateAccessPolicyResponse(
    accessPolicyDetail: Optional[
      zio.aws.opensearchserverless.model.AccessPolicyDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.UpdateAccessPolicyResponse = {
    import UpdateAccessPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.UpdateAccessPolicyResponse
      .builder()
      .optionallyWith(accessPolicyDetail.map(value => value.buildAwsValue()))(
        _.accessPolicyDetail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.UpdateAccessPolicyResponse.ReadOnly =
    zio.aws.opensearchserverless.model.UpdateAccessPolicyResponse
      .wrap(buildAwsValue())
}
object UpdateAccessPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.UpdateAccessPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.UpdateAccessPolicyResponse =
      zio.aws.opensearchserverless.model.UpdateAccessPolicyResponse(
        accessPolicyDetail.map(value => value.asEditable)
      )
    def accessPolicyDetail: Optional[
      zio.aws.opensearchserverless.model.AccessPolicyDetail.ReadOnly
    ]
    def getAccessPolicyDetail: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.AccessPolicyDetail.ReadOnly
    ] = AwsError.unwrapOptionField("accessPolicyDetail", accessPolicyDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateAccessPolicyResponse
  ) extends zio.aws.opensearchserverless.model.UpdateAccessPolicyResponse.ReadOnly {
    override val accessPolicyDetail: Optional[
      zio.aws.opensearchserverless.model.AccessPolicyDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accessPolicyDetail())
      .map(value =>
        zio.aws.opensearchserverless.model.AccessPolicyDetail.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateAccessPolicyResponse
  ): zio.aws.opensearchserverless.model.UpdateAccessPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
