package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetPoliciesStatsResponse(
    accessPolicyStats: Optional[
      zio.aws.opensearchserverless.model.AccessPolicyStats
    ] = Optional.Absent,
    securityConfigStats: Optional[
      zio.aws.opensearchserverless.model.SecurityConfigStats
    ] = Optional.Absent,
    securityPolicyStats: Optional[
      zio.aws.opensearchserverless.model.SecurityPolicyStats
    ] = Optional.Absent,
    totalPolicyCount: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.GetPoliciesStatsResponse = {
    import GetPoliciesStatsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.GetPoliciesStatsResponse
      .builder()
      .optionallyWith(accessPolicyStats.map(value => value.buildAwsValue()))(
        _.accessPolicyStats
      )
      .optionallyWith(securityConfigStats.map(value => value.buildAwsValue()))(
        _.securityConfigStats
      )
      .optionallyWith(securityPolicyStats.map(value => value.buildAwsValue()))(
        _.securityPolicyStats
      )
      .optionallyWith(totalPolicyCount.map(value => value: java.lang.Long))(
        _.totalPolicyCount
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.GetPoliciesStatsResponse.ReadOnly =
    zio.aws.opensearchserverless.model.GetPoliciesStatsResponse
      .wrap(buildAwsValue())
}
object GetPoliciesStatsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.GetPoliciesStatsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.GetPoliciesStatsResponse =
      zio.aws.opensearchserverless.model.GetPoliciesStatsResponse(
        accessPolicyStats.map(value => value.asEditable),
        securityConfigStats.map(value => value.asEditable),
        securityPolicyStats.map(value => value.asEditable),
        totalPolicyCount.map(value => value)
      )
    def accessPolicyStats: Optional[
      zio.aws.opensearchserverless.model.AccessPolicyStats.ReadOnly
    ]
    def securityConfigStats: Optional[
      zio.aws.opensearchserverless.model.SecurityConfigStats.ReadOnly
    ]
    def securityPolicyStats: Optional[
      zio.aws.opensearchserverless.model.SecurityPolicyStats.ReadOnly
    ]
    def totalPolicyCount: Optional[Long]
    def getAccessPolicyStats: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.AccessPolicyStats.ReadOnly
    ] = AwsError.unwrapOptionField("accessPolicyStats", accessPolicyStats)
    def getSecurityConfigStats: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.SecurityConfigStats.ReadOnly
    ] = AwsError.unwrapOptionField("securityConfigStats", securityConfigStats)
    def getSecurityPolicyStats: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.SecurityPolicyStats.ReadOnly
    ] = AwsError.unwrapOptionField("securityPolicyStats", securityPolicyStats)
    def getTotalPolicyCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("totalPolicyCount", totalPolicyCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.GetPoliciesStatsResponse
  ) extends zio.aws.opensearchserverless.model.GetPoliciesStatsResponse.ReadOnly {
    override val accessPolicyStats: Optional[
      zio.aws.opensearchserverless.model.AccessPolicyStats.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accessPolicyStats())
      .map(value =>
        zio.aws.opensearchserverless.model.AccessPolicyStats.wrap(value)
      )
    override val securityConfigStats: Optional[
      zio.aws.opensearchserverless.model.SecurityConfigStats.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.securityConfigStats())
      .map(value =>
        zio.aws.opensearchserverless.model.SecurityConfigStats.wrap(value)
      )
    override val securityPolicyStats: Optional[
      zio.aws.opensearchserverless.model.SecurityPolicyStats.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.securityPolicyStats())
      .map(value =>
        zio.aws.opensearchserverless.model.SecurityPolicyStats.wrap(value)
      )
    override val totalPolicyCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.totalPolicyCount())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.GetPoliciesStatsResponse
  ): zio.aws.opensearchserverless.model.GetPoliciesStatsResponse.ReadOnly =
    new Wrapper(impl)
}
