package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.SecurityConfigId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetSecurityConfigRequest(id: SecurityConfigId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.GetSecurityConfigRequest = {
    import GetSecurityConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.GetSecurityConfigRequest
      .builder()
      .id(SecurityConfigId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.GetSecurityConfigRequest.ReadOnly =
    zio.aws.opensearchserverless.model.GetSecurityConfigRequest
      .wrap(buildAwsValue())
}
object GetSecurityConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.GetSecurityConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.GetSecurityConfigRequest =
      zio.aws.opensearchserverless.model.GetSecurityConfigRequest(id)
    def id: SecurityConfigId
    def getId: ZIO[Any, Nothing, SecurityConfigId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.GetSecurityConfigRequest
  ) extends zio.aws.opensearchserverless.model.GetSecurityConfigRequest.ReadOnly {
    override val id: SecurityConfigId =
      zio.aws.opensearchserverless.model.primitives.SecurityConfigId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.GetSecurityConfigRequest
  ): zio.aws.opensearchserverless.model.GetSecurityConfigRequest.ReadOnly =
    new Wrapper(impl)
}
