package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateVpcEndpointResponse(
    updateVpcEndpointDetail: Optional[
      zio.aws.opensearchserverless.model.UpdateVpcEndpointDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.UpdateVpcEndpointResponse = {
    import UpdateVpcEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.UpdateVpcEndpointResponse
      .builder()
      .optionallyWith(
        updateVpcEndpointDetail.map(value => value.buildAwsValue())
      )(_.updateVpcEndpointDetail)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.UpdateVpcEndpointResponse.ReadOnly =
    zio.aws.opensearchserverless.model.UpdateVpcEndpointResponse
      .wrap(buildAwsValue())
}
object UpdateVpcEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.UpdateVpcEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.UpdateVpcEndpointResponse =
      zio.aws.opensearchserverless.model.UpdateVpcEndpointResponse(
        updateVpcEndpointDetail.map(value => value.asEditable)
      )
    def updateVpcEndpointDetail: Optional[
      zio.aws.opensearchserverless.model.UpdateVpcEndpointDetail.ReadOnly
    ]
    def getUpdateVpcEndpointDetail: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.UpdateVpcEndpointDetail.ReadOnly
    ] = AwsError.unwrapOptionField(
      "updateVpcEndpointDetail",
      updateVpcEndpointDetail
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateVpcEndpointResponse
  ) extends zio.aws.opensearchserverless.model.UpdateVpcEndpointResponse.ReadOnly {
    override val updateVpcEndpointDetail: Optional[
      zio.aws.opensearchserverless.model.UpdateVpcEndpointDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.updateVpcEndpointDetail())
      .map(value =>
        zio.aws.opensearchserverless.model.UpdateVpcEndpointDetail.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateVpcEndpointResponse
  ): zio.aws.opensearchserverless.model.UpdateVpcEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
