package zio.aws.opensearchserverless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.opensearchserverless.model.primitives.ListVpcEndpointsRequestMaxResultsInteger
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListVpcEndpointsRequest(
    maxResults: Optional[ListVpcEndpointsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    vpcEndpointFilters: Optional[
      zio.aws.opensearchserverless.model.VpcEndpointFilters
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsRequest = {
    import ListVpcEndpointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListVpcEndpointsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(vpcEndpointFilters.map(value => value.buildAwsValue()))(
        _.vpcEndpointFilters
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.ListVpcEndpointsRequest.ReadOnly =
    zio.aws.opensearchserverless.model.ListVpcEndpointsRequest
      .wrap(buildAwsValue())
}
object ListVpcEndpointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.ListVpcEndpointsRequest =
      zio.aws.opensearchserverless.model.ListVpcEndpointsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        vpcEndpointFilters.map(value => value.asEditable)
      )
    def maxResults: Optional[ListVpcEndpointsRequestMaxResultsInteger]
    def nextToken: Optional[String]
    def vpcEndpointFilters: Optional[
      zio.aws.opensearchserverless.model.VpcEndpointFilters.ReadOnly
    ]
    def getMaxResults
        : ZIO[Any, AwsError, ListVpcEndpointsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVpcEndpointFilters: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.VpcEndpointFilters.ReadOnly
    ] = AwsError.unwrapOptionField("vpcEndpointFilters", vpcEndpointFilters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsRequest
  ) extends zio.aws.opensearchserverless.model.ListVpcEndpointsRequest.ReadOnly {
    override val maxResults
        : Optional[ListVpcEndpointsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.opensearchserverless.model.primitives
            .ListVpcEndpointsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val vpcEndpointFilters: Optional[
      zio.aws.opensearchserverless.model.VpcEndpointFilters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointFilters())
      .map(value =>
        zio.aws.opensearchserverless.model.VpcEndpointFilters.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsRequest
  ): zio.aws.opensearchserverless.model.ListVpcEndpointsRequest.ReadOnly =
    new Wrapper(impl)
}
