package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSecurityPoliciesResponse(
    nextToken: Optional[String] = Optional.Absent,
    securityPolicySummaries: Optional[
      Iterable[zio.aws.opensearchserverless.model.SecurityPolicySummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesResponse = {
    import ListSecurityPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        securityPolicySummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityPolicySummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.ListSecurityPoliciesResponse.ReadOnly =
    zio.aws.opensearchserverless.model.ListSecurityPoliciesResponse
      .wrap(buildAwsValue())
}
object ListSecurityPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.ListSecurityPoliciesResponse =
      zio.aws.opensearchserverless.model.ListSecurityPoliciesResponse(
        nextToken.map(value => value),
        securityPolicySummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def securityPolicySummaries: Optional[
      List[zio.aws.opensearchserverless.model.SecurityPolicySummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSecurityPolicySummaries: ZIO[Any, AwsError, List[
      zio.aws.opensearchserverless.model.SecurityPolicySummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "securityPolicySummaries",
      securityPolicySummaries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesResponse
  ) extends zio.aws.opensearchserverless.model.ListSecurityPoliciesResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val securityPolicySummaries: Optional[
      List[zio.aws.opensearchserverless.model.SecurityPolicySummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.securityPolicySummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearchserverless.model.SecurityPolicySummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesResponse
  ): zio.aws.opensearchserverless.model.ListSecurityPoliciesResponse.ReadOnly =
    new Wrapper(impl)
}
