package zio.aws.opensearchserverless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.opensearchserverless.model.primitives.ListSecurityConfigsRequestMaxResultsInteger
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListSecurityConfigsRequest(
    maxResults: Optional[ListSecurityConfigsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    `type`: zio.aws.opensearchserverless.model.SecurityConfigType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsRequest = {
    import ListSecurityConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListSecurityConfigsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.ListSecurityConfigsRequest.ReadOnly =
    zio.aws.opensearchserverless.model.ListSecurityConfigsRequest
      .wrap(buildAwsValue())
}
object ListSecurityConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.ListSecurityConfigsRequest =
      zio.aws.opensearchserverless.model.ListSecurityConfigsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        `type`
      )
    def maxResults: Optional[ListSecurityConfigsRequestMaxResultsInteger]
    def nextToken: Optional[String]
    def `type`: zio.aws.opensearchserverless.model.SecurityConfigType
    def getMaxResults
        : ZIO[Any, AwsError, ListSecurityConfigsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.opensearchserverless.model.SecurityConfigType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsRequest
  ) extends zio.aws.opensearchserverless.model.ListSecurityConfigsRequest.ReadOnly {
    override val maxResults
        : Optional[ListSecurityConfigsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.opensearchserverless.model.primitives
            .ListSecurityConfigsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val `type`: zio.aws.opensearchserverless.model.SecurityConfigType =
      zio.aws.opensearchserverless.model.SecurityConfigType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsRequest
  ): zio.aws.opensearchserverless.model.ListSecurityConfigsRequest.ReadOnly =
    new Wrapper(impl)
}
