package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteVpcEndpointResponse(
    deleteVpcEndpointDetail: Optional[
      zio.aws.opensearchserverless.model.DeleteVpcEndpointDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.DeleteVpcEndpointResponse = {
    import DeleteVpcEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.DeleteVpcEndpointResponse
      .builder()
      .optionallyWith(
        deleteVpcEndpointDetail.map(value => value.buildAwsValue())
      )(_.deleteVpcEndpointDetail)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.DeleteVpcEndpointResponse.ReadOnly =
    zio.aws.opensearchserverless.model.DeleteVpcEndpointResponse
      .wrap(buildAwsValue())
}
object DeleteVpcEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.DeleteVpcEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.DeleteVpcEndpointResponse =
      zio.aws.opensearchserverless.model.DeleteVpcEndpointResponse(
        deleteVpcEndpointDetail.map(value => value.asEditable)
      )
    def deleteVpcEndpointDetail: Optional[
      zio.aws.opensearchserverless.model.DeleteVpcEndpointDetail.ReadOnly
    ]
    def getDeleteVpcEndpointDetail: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.DeleteVpcEndpointDetail.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deleteVpcEndpointDetail",
      deleteVpcEndpointDetail
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.DeleteVpcEndpointResponse
  ) extends zio.aws.opensearchserverless.model.DeleteVpcEndpointResponse.ReadOnly {
    override val deleteVpcEndpointDetail: Optional[
      zio.aws.opensearchserverless.model.DeleteVpcEndpointDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteVpcEndpointDetail())
      .map(value =>
        zio.aws.opensearchserverless.model.DeleteVpcEndpointDetail.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.DeleteVpcEndpointResponse
  ): zio.aws.opensearchserverless.model.DeleteVpcEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
