package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{
  CollectionName,
  CollectionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetCollectionRequest(
    ids: Optional[Iterable[CollectionId]] = Optional.Absent,
    names: Optional[Iterable[CollectionName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.BatchGetCollectionRequest = {
    import BatchGetCollectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.BatchGetCollectionRequest
      .builder()
      .optionallyWith(
        ids.map(value =>
          value.map { item =>
            CollectionId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ids)
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            CollectionName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.BatchGetCollectionRequest.ReadOnly =
    zio.aws.opensearchserverless.model.BatchGetCollectionRequest
      .wrap(buildAwsValue())
}
object BatchGetCollectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.BatchGetCollectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.BatchGetCollectionRequest =
      zio.aws.opensearchserverless.model.BatchGetCollectionRequest(
        ids.map(value => value),
        names.map(value => value)
      )
    def ids: Optional[List[CollectionId]]
    def names: Optional[List[CollectionName]]
    def getIds: ZIO[Any, AwsError, List[CollectionId]] =
      AwsError.unwrapOptionField("ids", ids)
    def getNames: ZIO[Any, AwsError, List[CollectionName]] =
      AwsError.unwrapOptionField("names", names)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.BatchGetCollectionRequest
  ) extends zio.aws.opensearchserverless.model.BatchGetCollectionRequest.ReadOnly {
    override val ids: Optional[List[CollectionId]] = zio.aws.core.internal
      .optionalFromNullable(impl.ids())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearchserverless.model.primitives.CollectionId(item)
        }.toList
      )
    override val names: Optional[List[CollectionName]] = zio.aws.core.internal
      .optionalFromNullable(impl.names())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearchserverless.model.primitives.CollectionName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.BatchGetCollectionRequest
  ): zio.aws.opensearchserverless.model.BatchGetCollectionRequest.ReadOnly =
    new Wrapper(impl)
}
