package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.VpcEndpointId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchGetVpcEndpointRequest(ids: Iterable[VpcEndpointId]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.BatchGetVpcEndpointRequest = {
    import BatchGetVpcEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.BatchGetVpcEndpointRequest
      .builder()
      .ids(ids.map { item =>
        VpcEndpointId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.BatchGetVpcEndpointRequest.ReadOnly =
    zio.aws.opensearchserverless.model.BatchGetVpcEndpointRequest
      .wrap(buildAwsValue())
}
object BatchGetVpcEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.BatchGetVpcEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.BatchGetVpcEndpointRequest =
      zio.aws.opensearchserverless.model.BatchGetVpcEndpointRequest(ids)
    def ids: List[VpcEndpointId]
    def getIds: ZIO[Any, Nothing, List[VpcEndpointId]] = ZIO.succeed(ids)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.BatchGetVpcEndpointRequest
  ) extends zio.aws.opensearchserverless.model.BatchGetVpcEndpointRequest.ReadOnly {
    override val ids: List[VpcEndpointId] = impl
      .ids()
      .asScala
      .map { item =>
        zio.aws.opensearchserverless.model.primitives.VpcEndpointId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.BatchGetVpcEndpointRequest
  ): zio.aws.opensearchserverless.model.BatchGetVpcEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
