package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SecurityPolicyStats(
    encryptionPolicyCount: Optional[Long] = Optional.Absent,
    networkPolicyCount: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.SecurityPolicyStats = {
    import SecurityPolicyStats.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.SecurityPolicyStats
      .builder()
      .optionallyWith(
        encryptionPolicyCount.map(value => value: java.lang.Long)
      )(_.encryptionPolicyCount)
      .optionallyWith(networkPolicyCount.map(value => value: java.lang.Long))(
        _.networkPolicyCount
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.SecurityPolicyStats.ReadOnly =
    zio.aws.opensearchserverless.model.SecurityPolicyStats.wrap(buildAwsValue())
}
object SecurityPolicyStats {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.SecurityPolicyStats
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.SecurityPolicyStats =
      zio.aws.opensearchserverless.model.SecurityPolicyStats(
        encryptionPolicyCount.map(value => value),
        networkPolicyCount.map(value => value)
      )
    def encryptionPolicyCount: Optional[Long]
    def networkPolicyCount: Optional[Long]
    def getEncryptionPolicyCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("encryptionPolicyCount", encryptionPolicyCount)
    def getNetworkPolicyCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("networkPolicyCount", networkPolicyCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.SecurityPolicyStats
  ) extends zio.aws.opensearchserverless.model.SecurityPolicyStats.ReadOnly {
    override val encryptionPolicyCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionPolicyCount())
      .map(value => value: Long)
    override val networkPolicyCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.networkPolicyCount())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.SecurityPolicyStats
  ): zio.aws.opensearchserverless.model.SecurityPolicyStats.ReadOnly =
    new Wrapper(impl)
}
