package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VpcEndpointFilters(
    status: Optional[zio.aws.opensearchserverless.model.VpcEndpointStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointFilters = {
    import VpcEndpointFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointFilters
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.VpcEndpointFilters.ReadOnly =
    zio.aws.opensearchserverless.model.VpcEndpointFilters.wrap(buildAwsValue())
}
object VpcEndpointFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.VpcEndpointFilters =
      zio.aws.opensearchserverless.model
        .VpcEndpointFilters(status.map(value => value))
    def status: Optional[zio.aws.opensearchserverless.model.VpcEndpointStatus]
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.VpcEndpointStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointFilters
  ) extends zio.aws.opensearchserverless.model.VpcEndpointFilters.ReadOnly {
    override val status
        : Optional[zio.aws.opensearchserverless.model.VpcEndpointStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.opensearchserverless.model.VpcEndpointStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointFilters
  ): zio.aws.opensearchserverless.model.VpcEndpointFilters.ReadOnly =
    new Wrapper(impl)
}
