package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: Arn,
    tags: Iterable[zio.aws.opensearchserverless.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.TagResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.TagResourceRequest.ReadOnly =
    zio.aws.opensearchserverless.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.TagResourceRequest =
      zio.aws.opensearchserverless.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: Arn
    def tags: List[zio.aws.opensearchserverless.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, List[
      zio.aws.opensearchserverless.model.Tag.ReadOnly
    ]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.TagResourceRequest
  ) extends zio.aws.opensearchserverless.model.TagResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.opensearchserverless.model.primitives.Arn(impl.resourceArn())
    override val tags: List[zio.aws.opensearchserverless.model.Tag.ReadOnly] =
      impl
        .tags()
        .asScala
        .map { item =>
          zio.aws.opensearchserverless.model.Tag.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.TagResourceRequest
  ): zio.aws.opensearchserverless.model.TagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
