package zio.aws.opensearchserverless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.opensearchserverless.model.primitives.{
  Resource,
  ListAccessPoliciesRequestMaxResultsInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAccessPoliciesRequest(
    maxResults: Optional[ListAccessPoliciesRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    resource: Optional[Iterable[Resource]] = Optional.Absent,
    `type`: zio.aws.opensearchserverless.model.AccessPolicyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesRequest = {
    import ListAccessPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListAccessPoliciesRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        resource.map(value =>
          value.map { item =>
            Resource.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resource)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.ListAccessPoliciesRequest.ReadOnly =
    zio.aws.opensearchserverless.model.ListAccessPoliciesRequest
      .wrap(buildAwsValue())
}
object ListAccessPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.ListAccessPoliciesRequest =
      zio.aws.opensearchserverless.model.ListAccessPoliciesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        resource.map(value => value),
        `type`
      )
    def maxResults: Optional[ListAccessPoliciesRequestMaxResultsInteger]
    def nextToken: Optional[String]
    def resource: Optional[List[Resource]]
    def `type`: zio.aws.opensearchserverless.model.AccessPolicyType
    def getMaxResults
        : ZIO[Any, AwsError, ListAccessPoliciesRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResource: ZIO[Any, AwsError, List[Resource]] =
      AwsError.unwrapOptionField("resource", resource)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.opensearchserverless.model.AccessPolicyType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesRequest
  ) extends zio.aws.opensearchserverless.model.ListAccessPoliciesRequest.ReadOnly {
    override val maxResults
        : Optional[ListAccessPoliciesRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.opensearchserverless.model.primitives
            .ListAccessPoliciesRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val resource: Optional[List[Resource]] = zio.aws.core.internal
      .optionalFromNullable(impl.resource())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearchserverless.model.primitives.Resource(item)
        }.toList
      )
    override val `type`: zio.aws.opensearchserverless.model.AccessPolicyType =
      zio.aws.opensearchserverless.model.AccessPolicyType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesRequest
  ): zio.aws.opensearchserverless.model.ListAccessPoliciesRequest.ReadOnly =
    new Wrapper(impl)
}
