package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSecurityPolicyResponse(
    securityPolicyDetail: Optional[
      zio.aws.opensearchserverless.model.SecurityPolicyDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.GetSecurityPolicyResponse = {
    import GetSecurityPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.GetSecurityPolicyResponse
      .builder()
      .optionallyWith(securityPolicyDetail.map(value => value.buildAwsValue()))(
        _.securityPolicyDetail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.GetSecurityPolicyResponse.ReadOnly =
    zio.aws.opensearchserverless.model.GetSecurityPolicyResponse
      .wrap(buildAwsValue())
}
object GetSecurityPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.GetSecurityPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.GetSecurityPolicyResponse =
      zio.aws.opensearchserverless.model.GetSecurityPolicyResponse(
        securityPolicyDetail.map(value => value.asEditable)
      )
    def securityPolicyDetail: Optional[
      zio.aws.opensearchserverless.model.SecurityPolicyDetail.ReadOnly
    ]
    def getSecurityPolicyDetail: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.SecurityPolicyDetail.ReadOnly
    ] = AwsError.unwrapOptionField("securityPolicyDetail", securityPolicyDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.GetSecurityPolicyResponse
  ) extends zio.aws.opensearchserverless.model.GetSecurityPolicyResponse.ReadOnly {
    override val securityPolicyDetail: Optional[
      zio.aws.opensearchserverless.model.SecurityPolicyDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.securityPolicyDetail())
      .map(value =>
        zio.aws.opensearchserverless.model.SecurityPolicyDetail.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.GetSecurityPolicyResponse
  ): zio.aws.opensearchserverless.model.GetSecurityPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
