package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSecurityConfigResponse(
    securityConfigDetail: Optional[
      zio.aws.opensearchserverless.model.SecurityConfigDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.GetSecurityConfigResponse = {
    import GetSecurityConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.GetSecurityConfigResponse
      .builder()
      .optionallyWith(securityConfigDetail.map(value => value.buildAwsValue()))(
        _.securityConfigDetail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.GetSecurityConfigResponse.ReadOnly =
    zio.aws.opensearchserverless.model.GetSecurityConfigResponse
      .wrap(buildAwsValue())
}
object GetSecurityConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.GetSecurityConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.GetSecurityConfigResponse =
      zio.aws.opensearchserverless.model.GetSecurityConfigResponse(
        securityConfigDetail.map(value => value.asEditable)
      )
    def securityConfigDetail: Optional[
      zio.aws.opensearchserverless.model.SecurityConfigDetail.ReadOnly
    ]
    def getSecurityConfigDetail: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.SecurityConfigDetail.ReadOnly
    ] = AwsError.unwrapOptionField("securityConfigDetail", securityConfigDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.GetSecurityConfigResponse
  ) extends zio.aws.opensearchserverless.model.GetSecurityConfigResponse.ReadOnly {
    override val securityConfigDetail: Optional[
      zio.aws.opensearchserverless.model.SecurityConfigDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.securityConfigDetail())
      .map(value =>
        zio.aws.opensearchserverless.model.SecurityConfigDetail.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.GetSecurityConfigResponse
  ): zio.aws.opensearchserverless.model.GetSecurityConfigResponse.ReadOnly =
    new Wrapper(impl)
}
