package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateAccessPolicyResponse(
    accessPolicyDetail: Optional[
      zio.aws.opensearchserverless.model.AccessPolicyDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.CreateAccessPolicyResponse = {
    import CreateAccessPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.CreateAccessPolicyResponse
      .builder()
      .optionallyWith(accessPolicyDetail.map(value => value.buildAwsValue()))(
        _.accessPolicyDetail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.CreateAccessPolicyResponse.ReadOnly =
    zio.aws.opensearchserverless.model.CreateAccessPolicyResponse
      .wrap(buildAwsValue())
}
object CreateAccessPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.CreateAccessPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.CreateAccessPolicyResponse =
      zio.aws.opensearchserverless.model.CreateAccessPolicyResponse(
        accessPolicyDetail.map(value => value.asEditable)
      )
    def accessPolicyDetail: Optional[
      zio.aws.opensearchserverless.model.AccessPolicyDetail.ReadOnly
    ]
    def getAccessPolicyDetail: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.AccessPolicyDetail.ReadOnly
    ] = AwsError.unwrapOptionField("accessPolicyDetail", accessPolicyDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CreateAccessPolicyResponse
  ) extends zio.aws.opensearchserverless.model.CreateAccessPolicyResponse.ReadOnly {
    override val accessPolicyDetail: Optional[
      zio.aws.opensearchserverless.model.AccessPolicyDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accessPolicyDetail())
      .map(value =>
        zio.aws.opensearchserverless.model.AccessPolicyDetail.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CreateAccessPolicyResponse
  ): zio.aws.opensearchserverless.model.CreateAccessPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
