package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{
  VpcEndpointId,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteVpcEndpointRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    id: VpcEndpointId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.DeleteVpcEndpointRequest = {
    import DeleteVpcEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.DeleteVpcEndpointRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .id(VpcEndpointId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.DeleteVpcEndpointRequest.ReadOnly =
    zio.aws.opensearchserverless.model.DeleteVpcEndpointRequest
      .wrap(buildAwsValue())
}
object DeleteVpcEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.DeleteVpcEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.DeleteVpcEndpointRequest =
      zio.aws.opensearchserverless.model
        .DeleteVpcEndpointRequest(clientToken.map(value => value), id)
    def clientToken: Optional[ClientToken]
    def id: VpcEndpointId
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getId: ZIO[Any, Nothing, VpcEndpointId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.DeleteVpcEndpointRequest
  ) extends zio.aws.opensearchserverless.model.DeleteVpcEndpointRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.ClientToken(value)
      )
    override val id: VpcEndpointId =
      zio.aws.opensearchserverless.model.primitives.VpcEndpointId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.DeleteVpcEndpointRequest
  ): zio.aws.opensearchserverless.model.DeleteVpcEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
