package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateLifecyclePolicyResponse(
    lifecyclePolicyDetail: Optional[
      zio.aws.opensearchserverless.model.LifecyclePolicyDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.UpdateLifecyclePolicyResponse = {
    import UpdateLifecyclePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.UpdateLifecyclePolicyResponse
      .builder()
      .optionallyWith(
        lifecyclePolicyDetail.map(value => value.buildAwsValue())
      )(_.lifecyclePolicyDetail)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.UpdateLifecyclePolicyResponse.ReadOnly =
    zio.aws.opensearchserverless.model.UpdateLifecyclePolicyResponse
      .wrap(buildAwsValue())
}
object UpdateLifecyclePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.UpdateLifecyclePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.UpdateLifecyclePolicyResponse =
      zio.aws.opensearchserverless.model.UpdateLifecyclePolicyResponse(
        lifecyclePolicyDetail.map(value => value.asEditable)
      )
    def lifecyclePolicyDetail: Optional[
      zio.aws.opensearchserverless.model.LifecyclePolicyDetail.ReadOnly
    ]
    def getLifecyclePolicyDetail: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.LifecyclePolicyDetail.ReadOnly
    ] =
      AwsError.unwrapOptionField("lifecyclePolicyDetail", lifecyclePolicyDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateLifecyclePolicyResponse
  ) extends zio.aws.opensearchserverless.model.UpdateLifecyclePolicyResponse.ReadOnly {
    override val lifecyclePolicyDetail: Optional[
      zio.aws.opensearchserverless.model.LifecyclePolicyDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lifecyclePolicyDetail())
      .map(value =>
        zio.aws.opensearchserverless.model.LifecyclePolicyDetail.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateLifecyclePolicyResponse
  ): zio.aws.opensearchserverless.model.UpdateLifecyclePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
