package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListLifecyclePoliciesResponse(
    lifecyclePolicySummaries: Optional[
      Iterable[zio.aws.opensearchserverless.model.LifecyclePolicySummary]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesResponse = {
    import ListLifecyclePoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesResponse
      .builder()
      .optionallyWith(
        lifecyclePolicySummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lifecyclePolicySummaries)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.ListLifecyclePoliciesResponse.ReadOnly =
    zio.aws.opensearchserverless.model.ListLifecyclePoliciesResponse
      .wrap(buildAwsValue())
}
object ListLifecyclePoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.ListLifecyclePoliciesResponse =
      zio.aws.opensearchserverless.model.ListLifecyclePoliciesResponse(
        lifecyclePolicySummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def lifecyclePolicySummaries: Optional[
      List[zio.aws.opensearchserverless.model.LifecyclePolicySummary.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getLifecyclePolicySummaries: ZIO[Any, AwsError, List[
      zio.aws.opensearchserverless.model.LifecyclePolicySummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "lifecyclePolicySummaries",
      lifecyclePolicySummaries
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesResponse
  ) extends zio.aws.opensearchserverless.model.ListLifecyclePoliciesResponse.ReadOnly {
    override val lifecyclePolicySummaries: Optional[
      List[zio.aws.opensearchserverless.model.LifecyclePolicySummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lifecyclePolicySummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearchserverless.model.LifecyclePolicySummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesResponse
  ): zio.aws.opensearchserverless.model.ListLifecyclePoliciesResponse.ReadOnly =
    new Wrapper(impl)
}
