package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{CollectionId, ClientToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteCollectionRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    id: CollectionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.DeleteCollectionRequest = {
    import DeleteCollectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.DeleteCollectionRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .id(CollectionId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.DeleteCollectionRequest.ReadOnly =
    zio.aws.opensearchserverless.model.DeleteCollectionRequest
      .wrap(buildAwsValue())
}
object DeleteCollectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.DeleteCollectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.DeleteCollectionRequest =
      zio.aws.opensearchserverless.model
        .DeleteCollectionRequest(clientToken.map(value => value), id)
    def clientToken: Optional[ClientToken]
    def id: CollectionId
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getId: ZIO[Any, Nothing, CollectionId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.DeleteCollectionRequest
  ) extends zio.aws.opensearchserverless.model.DeleteCollectionRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.ClientToken(value)
      )
    override val id: CollectionId =
      zio.aws.opensearchserverless.model.primitives.CollectionId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.DeleteCollectionRequest
  ): zio.aws.opensearchserverless.model.DeleteCollectionRequest.ReadOnly =
    new Wrapper(impl)
}
