package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{PolicyName, ClientToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteLifecyclePolicyRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    name: PolicyName,
    `type`: zio.aws.opensearchserverless.model.LifecyclePolicyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.DeleteLifecyclePolicyRequest = {
    import DeleteLifecyclePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.DeleteLifecyclePolicyRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .name(PolicyName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.DeleteLifecyclePolicyRequest.ReadOnly =
    zio.aws.opensearchserverless.model.DeleteLifecyclePolicyRequest
      .wrap(buildAwsValue())
}
object DeleteLifecyclePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.DeleteLifecyclePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.DeleteLifecyclePolicyRequest =
      zio.aws.opensearchserverless.model.DeleteLifecyclePolicyRequest(
        clientToken.map(value => value),
        name,
        `type`
      )
    def clientToken: Optional[ClientToken]
    def name: PolicyName
    def `type`: zio.aws.opensearchserverless.model.LifecyclePolicyType
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(name)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.opensearchserverless.model.LifecyclePolicyType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.DeleteLifecyclePolicyRequest
  ) extends zio.aws.opensearchserverless.model.DeleteLifecyclePolicyRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.ClientToken(value)
      )
    override val name: PolicyName =
      zio.aws.opensearchserverless.model.primitives.PolicyName(impl.name())
    override val `type`
        : zio.aws.opensearchserverless.model.LifecyclePolicyType =
      zio.aws.opensearchserverless.model.LifecyclePolicyType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.DeleteLifecyclePolicyRequest
  ): zio.aws.opensearchserverless.model.DeleteLifecyclePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
