package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateCollectionResponse(
    createCollectionDetail: Optional[
      zio.aws.opensearchserverless.model.CreateCollectionDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.CreateCollectionResponse = {
    import CreateCollectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.CreateCollectionResponse
      .builder()
      .optionallyWith(
        createCollectionDetail.map(value => value.buildAwsValue())
      )(_.createCollectionDetail)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.CreateCollectionResponse.ReadOnly =
    zio.aws.opensearchserverless.model.CreateCollectionResponse
      .wrap(buildAwsValue())
}
object CreateCollectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.CreateCollectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.CreateCollectionResponse =
      zio.aws.opensearchserverless.model.CreateCollectionResponse(
        createCollectionDetail.map(value => value.asEditable)
      )
    def createCollectionDetail: Optional[
      zio.aws.opensearchserverless.model.CreateCollectionDetail.ReadOnly
    ]
    def getCreateCollectionDetail: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.CreateCollectionDetail.ReadOnly
    ] = AwsError.unwrapOptionField(
      "createCollectionDetail",
      createCollectionDetail
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CreateCollectionResponse
  ) extends zio.aws.opensearchserverless.model.CreateCollectionResponse.ReadOnly {
    override val createCollectionDetail: Optional[
      zio.aws.opensearchserverless.model.CreateCollectionDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.createCollectionDetail())
      .map(value =>
        zio.aws.opensearchserverless.model.CreateCollectionDetail.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.CreateCollectionResponse
  ): zio.aws.opensearchserverless.model.CreateCollectionResponse.ReadOnly =
    new Wrapper(impl)
}
