package zio.aws.opensearchserverless.model
import scala.jdk.CollectionConverters._
sealed trait ResourceType {
  def unwrap
      : software.amazon.awssdk.services.opensearchserverless.model.ResourceType
}
object ResourceType {
  def wrap(
      value: software.amazon.awssdk.services.opensearchserverless.model.ResourceType
  ): zio.aws.opensearchserverless.model.ResourceType = value match {
    case software.amazon.awssdk.services.opensearchserverless.model.ResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearchserverless.model.ResourceType.INDEX =>
      val r = index
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearchserverless.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearchserverless.model.ResourceType =
      software.amazon.awssdk.services.opensearchserverless.model.ResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object index extends zio.aws.opensearchserverless.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.opensearchserverless.model.ResourceType =
      software.amazon.awssdk.services.opensearchserverless.model.ResourceType.INDEX
  }
}
