package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchGetLifecyclePolicyRequest(
    identifiers: Iterable[
      zio.aws.opensearchserverless.model.LifecyclePolicyIdentifier
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.BatchGetLifecyclePolicyRequest = {
    import BatchGetLifecyclePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.BatchGetLifecyclePolicyRequest
      .builder()
      .identifiers(identifiers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.BatchGetLifecyclePolicyRequest.ReadOnly =
    zio.aws.opensearchserverless.model.BatchGetLifecyclePolicyRequest
      .wrap(buildAwsValue())
}
object BatchGetLifecyclePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.BatchGetLifecyclePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.BatchGetLifecyclePolicyRequest =
      zio.aws.opensearchserverless.model
        .BatchGetLifecyclePolicyRequest(identifiers.map { item =>
          item.asEditable
        })
    def identifiers: List[
      zio.aws.opensearchserverless.model.LifecyclePolicyIdentifier.ReadOnly
    ]
    def getIdentifiers: ZIO[Any, Nothing, List[
      zio.aws.opensearchserverless.model.LifecyclePolicyIdentifier.ReadOnly
    ]] = ZIO.succeed(identifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.BatchGetLifecyclePolicyRequest
  ) extends zio.aws.opensearchserverless.model.BatchGetLifecyclePolicyRequest.ReadOnly {
    override val identifiers: List[
      zio.aws.opensearchserverless.model.LifecyclePolicyIdentifier.ReadOnly
    ] = impl
      .identifiers()
      .asScala
      .map { item =>
        zio.aws.opensearchserverless.model.LifecyclePolicyIdentifier.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.BatchGetLifecyclePolicyRequest
  ): zio.aws.opensearchserverless.model.BatchGetLifecyclePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
