package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AccountSettingsDetail(
    capacityLimits: Optional[
      zio.aws.opensearchserverless.model.CapacityLimits
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.AccountSettingsDetail = {
    import AccountSettingsDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.AccountSettingsDetail
      .builder()
      .optionallyWith(capacityLimits.map(value => value.buildAwsValue()))(
        _.capacityLimits
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.AccountSettingsDetail.ReadOnly =
    zio.aws.opensearchserverless.model.AccountSettingsDetail
      .wrap(buildAwsValue())
}
object AccountSettingsDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.AccountSettingsDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.AccountSettingsDetail =
      zio.aws.opensearchserverless.model
        .AccountSettingsDetail(capacityLimits.map(value => value.asEditable))
    def capacityLimits
        : Optional[zio.aws.opensearchserverless.model.CapacityLimits.ReadOnly]
    def getCapacityLimits: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.CapacityLimits.ReadOnly
    ] = AwsError.unwrapOptionField("capacityLimits", capacityLimits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.AccountSettingsDetail
  ) extends zio.aws.opensearchserverless.model.AccountSettingsDetail.ReadOnly {
    override val capacityLimits
        : Optional[zio.aws.opensearchserverless.model.CapacityLimits.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityLimits())
        .map(value =>
          zio.aws.opensearchserverless.model.CapacityLimits.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.AccountSettingsDetail
  ): zio.aws.opensearchserverless.model.AccountSettingsDetail.ReadOnly =
    new Wrapper(impl)
}
