package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.PolicyName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LifecyclePolicyErrorDetail(
    errorCode: Optional[String] = Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent,
    name: Optional[PolicyName] = Optional.Absent,
    `type`: Optional[zio.aws.opensearchserverless.model.LifecyclePolicyType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyErrorDetail = {
    import LifecyclePolicyErrorDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyErrorDetail
      .builder()
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(
        name.map(value => PolicyName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.LifecyclePolicyErrorDetail.ReadOnly =
    zio.aws.opensearchserverless.model.LifecyclePolicyErrorDetail
      .wrap(buildAwsValue())
}
object LifecyclePolicyErrorDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyErrorDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearchserverless.model.LifecyclePolicyErrorDetail =
      zio.aws.opensearchserverless.model.LifecyclePolicyErrorDetail(
        errorCode.map(value => value),
        errorMessage.map(value => value),
        name.map(value => value),
        `type`.map(value => value)
      )
    def errorCode: Optional[String]
    def errorMessage: Optional[String]
    def name: Optional[PolicyName]
    def `type`: Optional[zio.aws.opensearchserverless.model.LifecyclePolicyType]
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getName: ZIO[Any, AwsError, PolicyName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.LifecyclePolicyType
    ] = AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyErrorDetail
  ) extends zio.aws.opensearchserverless.model.LifecyclePolicyErrorDetail.ReadOnly {
    override val errorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => value: String)
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
    override val name: Optional[PolicyName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.PolicyName(value)
      )
    override val `type`
        : Optional[zio.aws.opensearchserverless.model.LifecyclePolicyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.opensearchserverless.model.LifecyclePolicyType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyErrorDetail
  ): zio.aws.opensearchserverless.model.LifecyclePolicyErrorDetail.ReadOnly =
    new Wrapper(impl)
}
