package zio.aws.opensearchserverless.model
import zio.aws.opensearchserverless.model.primitives.{
  CollectionName,
  CollectionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateCollectionDetail(
    arn: Optional[String] = Optional.Absent,
    createdDate: Optional[Long] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    id: Optional[CollectionId] = Optional.Absent,
    lastModifiedDate: Optional[Long] = Optional.Absent,
    name: Optional[CollectionName] = Optional.Absent,
    status: Optional[zio.aws.opensearchserverless.model.CollectionStatus] =
      Optional.Absent,
    `type`: Optional[zio.aws.opensearchserverless.model.CollectionType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.UpdateCollectionDetail = {
    import UpdateCollectionDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.UpdateCollectionDetail
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(createdDate.map(value => value: java.lang.Long))(
        _.createdDate
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        id.map(value => CollectionId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(lastModifiedDate.map(value => value: java.lang.Long))(
        _.lastModifiedDate
      )
      .optionallyWith(
        name.map(value => CollectionName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.UpdateCollectionDetail.ReadOnly =
    zio.aws.opensearchserverless.model.UpdateCollectionDetail
      .wrap(buildAwsValue())
}
object UpdateCollectionDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.UpdateCollectionDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.UpdateCollectionDetail =
      zio.aws.opensearchserverless.model.UpdateCollectionDetail(
        arn.map(value => value),
        createdDate.map(value => value),
        description.map(value => value),
        id.map(value => value),
        lastModifiedDate.map(value => value),
        name.map(value => value),
        status.map(value => value),
        `type`.map(value => value)
      )
    def arn: Optional[String]
    def createdDate: Optional[Long]
    def description: Optional[String]
    def id: Optional[CollectionId]
    def lastModifiedDate: Optional[Long]
    def name: Optional[CollectionName]
    def status: Optional[zio.aws.opensearchserverless.model.CollectionStatus]
    def `type`: Optional[zio.aws.opensearchserverless.model.CollectionType]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedDate: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, AwsError, CollectionId] =
      AwsError.unwrapOptionField("id", id)
    def getLastModifiedDate: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getName: ZIO[Any, AwsError, CollectionName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.CollectionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.CollectionType
    ] = AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateCollectionDetail
  ) extends zio.aws.opensearchserverless.model.UpdateCollectionDetail.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val createdDate: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => value: Long)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val id: Optional[CollectionId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.CollectionId(value)
      )
    override val lastModifiedDate: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => value: Long)
    override val name: Optional[CollectionName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.opensearchserverless.model.primitives.CollectionName(value)
      )
    override val status
        : Optional[zio.aws.opensearchserverless.model.CollectionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.opensearchserverless.model.CollectionStatus.wrap(value)
        )
    override val `type`
        : Optional[zio.aws.opensearchserverless.model.CollectionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.opensearchserverless.model.CollectionType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.UpdateCollectionDetail
  ): zio.aws.opensearchserverless.model.UpdateCollectionDetail.ReadOnly =
    new Wrapper(impl)
}
