package zio.aws.opensearchserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAccessPolicyResponse(
    accessPolicyDetail: Optional[
      zio.aws.opensearchserverless.model.AccessPolicyDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearchserverless.model.GetAccessPolicyResponse = {
    import GetAccessPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearchserverless.model.GetAccessPolicyResponse
      .builder()
      .optionallyWith(accessPolicyDetail.map(value => value.buildAwsValue()))(
        _.accessPolicyDetail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearchserverless.model.GetAccessPolicyResponse.ReadOnly =
    zio.aws.opensearchserverless.model.GetAccessPolicyResponse
      .wrap(buildAwsValue())
}
object GetAccessPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearchserverless.model.GetAccessPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearchserverless.model.GetAccessPolicyResponse =
      zio.aws.opensearchserverless.model.GetAccessPolicyResponse(
        accessPolicyDetail.map(value => value.asEditable)
      )
    def accessPolicyDetail: Optional[
      zio.aws.opensearchserverless.model.AccessPolicyDetail.ReadOnly
    ]
    def getAccessPolicyDetail: ZIO[
      Any,
      AwsError,
      zio.aws.opensearchserverless.model.AccessPolicyDetail.ReadOnly
    ] = AwsError.unwrapOptionField("accessPolicyDetail", accessPolicyDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearchserverless.model.GetAccessPolicyResponse
  ) extends zio.aws.opensearchserverless.model.GetAccessPolicyResponse.ReadOnly {
    override val accessPolicyDetail: Optional[
      zio.aws.opensearchserverless.model.AccessPolicyDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accessPolicyDetail())
      .map(value =>
        zio.aws.opensearchserverless.model.AccessPolicyDetail.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearchserverless.model.GetAccessPolicyResponse
  ): zio.aws.opensearchserverless.model.GetAccessPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
