package zio.aws.opensearchserverless
import zio.aws.opensearchserverless.model.UpdateSecurityPolicyResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.opensearchserverless.OpenSearchServerlessAsyncClient
import zio.aws.core.AwsError
import zio.aws.opensearchserverless.model.{
  BatchGetVpcEndpointRequest,
  UpdateSecurityPolicyRequest,
  BatchGetCollectionRequest,
  CreateCollectionRequest,
  GetPoliciesStatsRequest,
  DeleteCollectionRequest,
  UpdateAccountSettingsRequest,
  CreateAccessPolicyRequest,
  UpdateVpcEndpointRequest,
  BatchGetEffectiveLifecyclePolicyRequest,
  ListSecurityPoliciesRequest,
  DeleteSecurityPolicyRequest,
  DeleteAccessPolicyRequest,
  UpdateSecurityConfigRequest,
  UpdateCollectionRequest,
  DeleteSecurityConfigRequest,
  ListTagsForResourceRequest,
  ListVpcEndpointsRequest,
  ListSecurityConfigsRequest,
  CreateLifecyclePolicyRequest,
  GetSecurityConfigRequest,
  DeleteVpcEndpointRequest,
  ListCollectionsRequest,
  DeleteLifecyclePolicyRequest,
  GetAccessPolicyRequest,
  GetSecurityPolicyRequest,
  CreateVpcEndpointRequest,
  BatchGetLifecyclePolicyRequest,
  UntagResourceRequest,
  CreateSecurityConfigRequest,
  UpdateAccessPolicyRequest,
  GetAccountSettingsRequest,
  CreateSecurityPolicyRequest,
  TagResourceRequest,
  ListLifecyclePoliciesRequest,
  UpdateLifecyclePolicyRequest,
  ListAccessPoliciesRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
object OpenSearchServerlessMock extends Mock[OpenSearchServerless] {
  object UpdateAccessPolicy
      extends Effect[
        UpdateAccessPolicyRequest,
        AwsError,
        zio.aws.opensearchserverless.model.UpdateAccessPolicyResponse.ReadOnly
      ]
  object BatchGetLifecyclePolicy
      extends Effect[
        BatchGetLifecyclePolicyRequest,
        AwsError,
        zio.aws.opensearchserverless.model.BatchGetLifecyclePolicyResponse.ReadOnly
      ]
  object ListSecurityPolicies
      extends Effect[
        ListSecurityPoliciesRequest,
        AwsError,
        zio.aws.opensearchserverless.model.ListSecurityPoliciesResponse.ReadOnly
      ]
  object CreateCollection
      extends Effect[
        CreateCollectionRequest,
        AwsError,
        zio.aws.opensearchserverless.model.CreateCollectionResponse.ReadOnly
      ]
  object CreateAccessPolicy
      extends Effect[
        CreateAccessPolicyRequest,
        AwsError,
        zio.aws.opensearchserverless.model.CreateAccessPolicyResponse.ReadOnly
      ]
  object BatchGetVpcEndpoint
      extends Effect[
        BatchGetVpcEndpointRequest,
        AwsError,
        zio.aws.opensearchserverless.model.BatchGetVpcEndpointResponse.ReadOnly
      ]
  object UpdateSecurityConfig
      extends Effect[
        UpdateSecurityConfigRequest,
        AwsError,
        zio.aws.opensearchserverless.model.UpdateSecurityConfigResponse.ReadOnly
      ]
  object GetPoliciesStats
      extends Effect[
        GetPoliciesStatsRequest,
        AwsError,
        zio.aws.opensearchserverless.model.GetPoliciesStatsResponse.ReadOnly
      ]
  object CreateSecurityConfig
      extends Effect[
        CreateSecurityConfigRequest,
        AwsError,
        zio.aws.opensearchserverless.model.CreateSecurityConfigResponse.ReadOnly
      ]
  object CreateSecurityPolicy
      extends Effect[
        CreateSecurityPolicyRequest,
        AwsError,
        zio.aws.opensearchserverless.model.CreateSecurityPolicyResponse.ReadOnly
      ]
  object DeleteCollection
      extends Effect[
        DeleteCollectionRequest,
        AwsError,
        zio.aws.opensearchserverless.model.DeleteCollectionResponse.ReadOnly
      ]
  object DeleteAccessPolicy
      extends Effect[
        DeleteAccessPolicyRequest,
        AwsError,
        zio.aws.opensearchserverless.model.DeleteAccessPolicyResponse.ReadOnly
      ]
  object GetSecurityConfig
      extends Effect[
        GetSecurityConfigRequest,
        AwsError,
        zio.aws.opensearchserverless.model.GetSecurityConfigResponse.ReadOnly
      ]
  object GetAccessPolicy
      extends Effect[
        GetAccessPolicyRequest,
        AwsError,
        zio.aws.opensearchserverless.model.GetAccessPolicyResponse.ReadOnly
      ]
  object ListAccessPolicies
      extends Effect[
        ListAccessPoliciesRequest,
        AwsError,
        zio.aws.opensearchserverless.model.ListAccessPoliciesResponse.ReadOnly
      ]
  object DeleteLifecyclePolicy
      extends Effect[
        DeleteLifecyclePolicyRequest,
        AwsError,
        zio.aws.opensearchserverless.model.DeleteLifecyclePolicyResponse.ReadOnly
      ]
  object BatchGetEffectiveLifecyclePolicy
      extends Effect[
        BatchGetEffectiveLifecyclePolicyRequest,
        AwsError,
        zio.aws.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.opensearchserverless.model.UntagResourceResponse.ReadOnly
      ]
  object DeleteSecurityPolicy
      extends Effect[
        DeleteSecurityPolicyRequest,
        AwsError,
        zio.aws.opensearchserverless.model.DeleteSecurityPolicyResponse.ReadOnly
      ]
  object ListVpcEndpoints
      extends Effect[
        ListVpcEndpointsRequest,
        AwsError,
        zio.aws.opensearchserverless.model.ListVpcEndpointsResponse.ReadOnly
      ]
  object DeleteVpcEndpoint
      extends Effect[
        DeleteVpcEndpointRequest,
        AwsError,
        zio.aws.opensearchserverless.model.DeleteVpcEndpointResponse.ReadOnly
      ]
  object CreateVpcEndpoint
      extends Effect[
        CreateVpcEndpointRequest,
        AwsError,
        zio.aws.opensearchserverless.model.CreateVpcEndpointResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.opensearchserverless.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.opensearchserverless.model.TagResourceResponse.ReadOnly
      ]
  object UpdateAccountSettings
      extends Effect[
        UpdateAccountSettingsRequest,
        AwsError,
        zio.aws.opensearchserverless.model.UpdateAccountSettingsResponse.ReadOnly
      ]
  object DeleteSecurityConfig
      extends Effect[
        DeleteSecurityConfigRequest,
        AwsError,
        zio.aws.opensearchserverless.model.DeleteSecurityConfigResponse.ReadOnly
      ]
  object ListCollections
      extends Effect[
        ListCollectionsRequest,
        AwsError,
        zio.aws.opensearchserverless.model.ListCollectionsResponse.ReadOnly
      ]
  object ListLifecyclePolicies
      extends Effect[
        ListLifecyclePoliciesRequest,
        AwsError,
        zio.aws.opensearchserverless.model.ListLifecyclePoliciesResponse.ReadOnly
      ]
  object UpdateCollection
      extends Effect[
        UpdateCollectionRequest,
        AwsError,
        zio.aws.opensearchserverless.model.UpdateCollectionResponse.ReadOnly
      ]
  object CreateLifecyclePolicy
      extends Effect[
        CreateLifecyclePolicyRequest,
        AwsError,
        zio.aws.opensearchserverless.model.CreateLifecyclePolicyResponse.ReadOnly
      ]
  object GetAccountSettings
      extends Effect[
        GetAccountSettingsRequest,
        AwsError,
        zio.aws.opensearchserverless.model.GetAccountSettingsResponse.ReadOnly
      ]
  object ListSecurityConfigs
      extends Effect[
        ListSecurityConfigsRequest,
        AwsError,
        zio.aws.opensearchserverless.model.ListSecurityConfigsResponse.ReadOnly
      ]
  object GetSecurityPolicy
      extends Effect[
        GetSecurityPolicyRequest,
        AwsError,
        zio.aws.opensearchserverless.model.GetSecurityPolicyResponse.ReadOnly
      ]
  object UpdateVpcEndpoint
      extends Effect[
        UpdateVpcEndpointRequest,
        AwsError,
        zio.aws.opensearchserverless.model.UpdateVpcEndpointResponse.ReadOnly
      ]
  object UpdateSecurityPolicy
      extends Effect[UpdateSecurityPolicyRequest, AwsError, ReadOnly]
  object UpdateLifecyclePolicy
      extends Effect[
        UpdateLifecyclePolicyRequest,
        AwsError,
        zio.aws.opensearchserverless.model.UpdateLifecyclePolicyResponse.ReadOnly
      ]
  object BatchGetCollection
      extends Effect[
        BatchGetCollectionRequest,
        AwsError,
        zio.aws.opensearchserverless.model.BatchGetCollectionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, OpenSearchServerless] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, OpenSearchServerless] { rts =>
        zio.ZIO.succeed {
          new OpenSearchServerless {
            val api: OpenSearchServerlessAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): OpenSearchServerless = this
            def updateAccessPolicy(request: UpdateAccessPolicyRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.UpdateAccessPolicyResponse.ReadOnly
            ] = proxy(UpdateAccessPolicy, request)
            def batchGetLifecyclePolicy(
                request: BatchGetLifecyclePolicyRequest
            ): IO[
              AwsError,
              zio.aws.opensearchserverless.model.BatchGetLifecyclePolicyResponse.ReadOnly
            ] = proxy(BatchGetLifecyclePolicy, request)
            def listSecurityPolicies(request: ListSecurityPoliciesRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.ListSecurityPoliciesResponse.ReadOnly
            ] = proxy(ListSecurityPolicies, request)
            def createCollection(request: CreateCollectionRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.CreateCollectionResponse.ReadOnly
            ] = proxy(CreateCollection, request)
            def createAccessPolicy(request: CreateAccessPolicyRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.CreateAccessPolicyResponse.ReadOnly
            ] = proxy(CreateAccessPolicy, request)
            def batchGetVpcEndpoint(request: BatchGetVpcEndpointRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.BatchGetVpcEndpointResponse.ReadOnly
            ] = proxy(BatchGetVpcEndpoint, request)
            def updateSecurityConfig(request: UpdateSecurityConfigRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.UpdateSecurityConfigResponse.ReadOnly
            ] = proxy(UpdateSecurityConfig, request)
            def getPoliciesStats(request: GetPoliciesStatsRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.GetPoliciesStatsResponse.ReadOnly
            ] = proxy(GetPoliciesStats, request)
            def createSecurityConfig(request: CreateSecurityConfigRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.CreateSecurityConfigResponse.ReadOnly
            ] = proxy(CreateSecurityConfig, request)
            def createSecurityPolicy(request: CreateSecurityPolicyRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.CreateSecurityPolicyResponse.ReadOnly
            ] = proxy(CreateSecurityPolicy, request)
            def deleteCollection(request: DeleteCollectionRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.DeleteCollectionResponse.ReadOnly
            ] = proxy(DeleteCollection, request)
            def deleteAccessPolicy(request: DeleteAccessPolicyRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.DeleteAccessPolicyResponse.ReadOnly
            ] = proxy(DeleteAccessPolicy, request)
            def getSecurityConfig(request: GetSecurityConfigRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.GetSecurityConfigResponse.ReadOnly
            ] = proxy(GetSecurityConfig, request)
            def getAccessPolicy(request: GetAccessPolicyRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.GetAccessPolicyResponse.ReadOnly
            ] = proxy(GetAccessPolicy, request)
            def listAccessPolicies(request: ListAccessPoliciesRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.ListAccessPoliciesResponse.ReadOnly
            ] = proxy(ListAccessPolicies, request)
            def deleteLifecyclePolicy(
                request: DeleteLifecyclePolicyRequest
            ): IO[
              AwsError,
              zio.aws.opensearchserverless.model.DeleteLifecyclePolicyResponse.ReadOnly
            ] = proxy(DeleteLifecyclePolicy, request)
            def batchGetEffectiveLifecyclePolicy(
                request: BatchGetEffectiveLifecyclePolicyRequest
            ): IO[
              AwsError,
              zio.aws.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyResponse.ReadOnly
            ] = proxy(BatchGetEffectiveLifecyclePolicy, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def deleteSecurityPolicy(request: DeleteSecurityPolicyRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.DeleteSecurityPolicyResponse.ReadOnly
            ] = proxy(DeleteSecurityPolicy, request)
            def listVpcEndpoints(request: ListVpcEndpointsRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.ListVpcEndpointsResponse.ReadOnly
            ] = proxy(ListVpcEndpoints, request)
            def deleteVpcEndpoint(request: DeleteVpcEndpointRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.DeleteVpcEndpointResponse.ReadOnly
            ] = proxy(DeleteVpcEndpoint, request)
            def createVpcEndpoint(request: CreateVpcEndpointRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.CreateVpcEndpointResponse.ReadOnly
            ] = proxy(CreateVpcEndpoint, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def updateAccountSettings(
                request: UpdateAccountSettingsRequest
            ): IO[
              AwsError,
              zio.aws.opensearchserverless.model.UpdateAccountSettingsResponse.ReadOnly
            ] = proxy(UpdateAccountSettings, request)
            def deleteSecurityConfig(request: DeleteSecurityConfigRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.DeleteSecurityConfigResponse.ReadOnly
            ] = proxy(DeleteSecurityConfig, request)
            def listCollections(request: ListCollectionsRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.ListCollectionsResponse.ReadOnly
            ] = proxy(ListCollections, request)
            def listLifecyclePolicies(
                request: ListLifecyclePoliciesRequest
            ): IO[
              AwsError,
              zio.aws.opensearchserverless.model.ListLifecyclePoliciesResponse.ReadOnly
            ] = proxy(ListLifecyclePolicies, request)
            def updateCollection(request: UpdateCollectionRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.UpdateCollectionResponse.ReadOnly
            ] = proxy(UpdateCollection, request)
            def createLifecyclePolicy(
                request: CreateLifecyclePolicyRequest
            ): IO[
              AwsError,
              zio.aws.opensearchserverless.model.CreateLifecyclePolicyResponse.ReadOnly
            ] = proxy(CreateLifecyclePolicy, request)
            def getAccountSettings(request: GetAccountSettingsRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.GetAccountSettingsResponse.ReadOnly
            ] = proxy(GetAccountSettings, request)
            def listSecurityConfigs(request: ListSecurityConfigsRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.ListSecurityConfigsResponse.ReadOnly
            ] = proxy(ListSecurityConfigs, request)
            def getSecurityPolicy(request: GetSecurityPolicyRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.GetSecurityPolicyResponse.ReadOnly
            ] = proxy(GetSecurityPolicy, request)
            def updateVpcEndpoint(request: UpdateVpcEndpointRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.UpdateVpcEndpointResponse.ReadOnly
            ] = proxy(UpdateVpcEndpoint, request)
            def updateSecurityPolicy(
                request: UpdateSecurityPolicyRequest
            ): IO[AwsError, ReadOnly] = proxy(UpdateSecurityPolicy, request)
            def updateLifecyclePolicy(
                request: UpdateLifecyclePolicyRequest
            ): IO[
              AwsError,
              zio.aws.opensearchserverless.model.UpdateLifecyclePolicyResponse.ReadOnly
            ] = proxy(UpdateLifecyclePolicy, request)
            def batchGetCollection(request: BatchGetCollectionRequest): IO[
              AwsError,
              zio.aws.opensearchserverless.model.BatchGetCollectionResponse.ReadOnly
            ] = proxy(BatchGetCollection, request)
          }
        }
      }
    }
  }
}
